/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.metrics;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import io.prometheus.client.Summary;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;

public class ResponseLengthCountingOutputStreamMetrics
extends CountingOutputStream {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ResponseLengthCountingOutputStreamMetrics.class);
    public static final Summary SENT_BYTES = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("vitam_responses_size_bytes")).labelNames(new String[]{"tenant", "method"})).help("Vitam responses size in bytes per tenant and method")).register();
    private final ContainerRequestContext requestContext;
    private boolean first = true;

    public ResponseLengthCountingOutputStreamMetrics(ContainerRequestContext requestContext, OutputStream outputStream) {
        super(outputStream);
        ParametersChecker.checkParameter((String)"RequestContext param is required", (Object[])new Object[]{requestContext});
        this.requestContext = requestContext;
    }

    public void close() throws IOException {
        if (this.first) {
            this.first = false;
            this.onCloseOfOutputStream();
        }
        super.close();
    }

    private void onCloseOfOutputStream() {
        try {
            String headerString = this.requestContext.getHeaderString("X-Tenant-Id");
            String tenant = headerString == null ? "unknown_tenant" : headerString;
            String method = this.requestContext.getMethod();
            ((Summary.Child)SENT_BYTES.labels(new String[]{tenant, method})).observe((double)super.getByteCount());
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
        }
    }
}

