/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.metrics;

import fr.gouv.vitam.common.LocalDateUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@ThreadSafe
public final class PassiveExpiringCache<K, V> {
    private final Duration cacheValidityDuration;
    private final Map<K, Pair<Instant, V>> cacheMap;

    public PassiveExpiringCache(long cacheDuration, TimeUnit cacheDurationUnit) {
        this.cacheValidityDuration = Duration.of(cacheDuration, cacheDurationUnit.toChronoUnit());
        this.cacheMap = new HashMap<K, Pair<Instant, V>>();
    }

    public synchronized void put(K key, V value) {
        this.cacheMap.put(key, (Pair<Instant, ImmutablePair>)new ImmutablePair((Object)LocalDateUtil.getInstant(), value));
    }

    public synchronized V get(K key) {
        Pair<Instant, V> valueWithTimestamp = this.cacheMap.get(key);
        if (valueWithTimestamp == null) {
            return null;
        }
        Instant now = LocalDateUtil.getInstant();
        if (Duration.between((Temporal)valueWithTimestamp.getLeft(), now).compareTo(this.cacheValidityDuration) > 0) {
            this.cacheMap.remove(key);
            return null;
        }
        return (V)valueWithTimestamp.getRight();
    }
}

