/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class DynamicGauge
extends Collector
implements Collector.Describable {
    private final String name;
    private final String help;
    private final List<String> labelNames;
    private final Supplier<Map<List<String>, Double>> metricsProvider;

    public DynamicGauge(String name, String help, List<String> labelNames, Supplier<Map<List<String>, Double>> metricsSupplier) {
        this.name = name;
        this.help = help;
        this.labelNames = labelNames;
        this.metricsProvider = metricsSupplier;
    }

    public List<Collector.MetricFamilySamples> describe() {
        return List.of(new GaugeMetricFamily(this.name, this.help, this.labelNames));
    }

    public List<Collector.MetricFamilySamples> collect() {
        GaugeMetricFamily metricFamily = new GaugeMetricFamily(this.name, this.help, this.labelNames);
        Map<List<String>, Double> metricValuesByLabelValues = this.metricsProvider.get();
        for (Map.Entry<List<String>, Double> entry : metricValuesByLabelValues.entrySet()) {
            if (entry.getValue() == null) continue;
            metricFamily.addMetric(entry.getKey(), entry.getValue().doubleValue());
        }
        return List.of(metricFamily);
    }
}

