/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.mapping.dip;

import fr.gouv.culture.archivesdefrance.seda.v2.AppraisalRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.ClassificationRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.FinalActionAppraisalCodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.FinalActionStorageCodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.HoldRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.ObjectFactory;
import fr.gouv.culture.archivesdefrance.seda.v2.RuleIdType;
import fr.gouv.culture.archivesdefrance.seda.v2.StorageRuleType;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.model.unit.CommonRule;
import fr.gouv.vitam.common.model.unit.InheritanceModel;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class RuleMapper {
    private final ObjectFactory objectFactory = new ObjectFactory();

    public <T extends CommonRule> T fillCommonRule(RuleCategoryModel ruleCategory, Supplier<T> commonRuleSupplier) throws DatatypeConfigurationException {
        if (ruleCategory == null) {
            return null;
        }
        CommonRule commonRule = (CommonRule)commonRuleSupplier.get();
        InheritanceModel inheritance = ruleCategory.getInheritance();
        if (inheritance != null) {
            commonRule.getRefNonRuleId().addAll(this.mapPreventRuleIds(inheritance));
            if (commonRule.getRefNonRuleId().isEmpty()) {
                commonRule.setPreventInheritance(inheritance.isPreventInheritance());
            }
        }
        ArrayList<Object> ruleAndStartDate = new ArrayList<Object>();
        List<RuleModel> rules = ruleCategory.getRules();
        for (RuleModel rule : rules) {
            RuleIdType ruleIdType = new RuleIdType();
            if (ParametersChecker.isNotEmpty((String[])new String[]{rule.getRule()})) {
                ruleIdType.setValue(rule.getRule());
                ruleAndStartDate.add(ruleIdType);
            }
            String startDate = rule.getStartDate();
            if (!ParametersChecker.isNotEmpty((String[])new String[]{startDate})) continue;
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(startDate);
            ruleAndStartDate.add(xmlGregorianCalendar);
        }
        commonRule.getRuleAndStartDate().addAll(ruleAndStartDate);
        if (commonRule instanceof ClassificationRuleType) {
            ClassificationRuleType crt = (ClassificationRuleType)commonRule;
            crt.setClassificationAudience(ruleCategory.getClassificationAudience());
            crt.setClassificationLevel(ruleCategory.getClassificationLevel());
            crt.setClassificationOwner(ruleCategory.getClassificationOwner());
            crt.setNeedReassessingAuthorization(ruleCategory.isNeedReassessingAuthorization());
            String classificationReassessingDate = ruleCategory.getClassificationReassessingDate();
            if (ParametersChecker.isNotEmpty((String[])new String[]{classificationReassessingDate})) {
                XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(classificationReassessingDate);
                crt.setClassificationReassessingDate(xmlGregorianCalendar);
            }
        }
        String finalAction = ruleCategory.getFinalAction();
        if (ParametersChecker.isNotEmpty((String[])new String[]{finalAction})) {
            try {
                if (commonRule instanceof StorageRuleType) {
                    StorageRuleType srt = (StorageRuleType)commonRule;
                    srt.setFinalAction(FinalActionStorageCodeType.fromValue(finalAction));
                } else if (commonRule instanceof AppraisalRuleType) {
                    AppraisalRuleType art = (AppraisalRuleType)commonRule;
                    art.setFinalAction(FinalActionAppraisalCodeType.fromValue(finalAction));
                }
            }
            catch (IllegalArgumentException e) {
                throw new DatatypeConfigurationException(e);
            }
        }
        return (T)commonRule;
    }

    public HoldRuleType fillHoldRule(RuleCategoryModel ruleCategory) throws DatatypeConfigurationException {
        if (ruleCategory == null) {
            return null;
        }
        HoldRuleType holdRuleType = this.objectFactory.createHoldRuleType();
        InheritanceModel inheritance = ruleCategory.getInheritance();
        if (inheritance != null) {
            holdRuleType.getRefNonRuleId().addAll(this.mapPreventRuleIds(inheritance));
            if (holdRuleType.getRefNonRuleId().isEmpty()) {
                holdRuleType.setPreventInheritance(inheritance.isPreventInheritance());
            }
        }
        for (RuleModel rule : ruleCategory.getRules()) {
            RuleIdType ruleIdType = this.objectFactory.createRuleIdType();
            ruleIdType.setValue(rule.getRule());
            holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypeRule(ruleIdType));
            if (rule.getStartDate() != null) {
                holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypeStartDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(rule.getStartDate())));
            }
            if (rule.getHoldEndDate() != null) {
                holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypeHoldEndDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(rule.getHoldEndDate())));
            }
            if (rule.getHoldOwner() != null) {
                holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypeHoldOwner(rule.getHoldOwner()));
            }
            if (rule.getHoldReassessingDate() != null) {
                holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypeHoldReassessingDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(rule.getHoldReassessingDate())));
            }
            if (rule.getHoldReason() != null) {
                holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypeHoldReason(rule.getHoldReason()));
            }
            if (rule.getPreventRearrangement() == null) continue;
            holdRuleType.getHoldRuleDefGroup().add(this.objectFactory.createHoldRuleTypePreventRearrangement(rule.getPreventRearrangement()));
        }
        return holdRuleType;
    }

    private List<RuleIdType> mapPreventRuleIds(InheritanceModel inheritance) {
        return inheritance.getPreventRulesId().stream().map(ruleId -> {
            RuleIdType ruleIdType = new RuleIdType();
            ruleIdType.setValue((String)ruleId);
            return ruleIdType;
        }).collect(Collectors.toList());
    }
}

