/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.json;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SchemaValidationUtils {
    private static final String PROPERTIES = "properties";
    private static final String ITEMS = "items";
    private static final String PATTERN_PROPERTIES = "patternProperties";

    public static List<String> extractFieldsFromSchema(String schemaJsonAsString) throws InvalidParseOperationException {
        HashSet<String> propertySet = new HashSet<String>();
        JsonNode externalSchema = JsonHandler.getFromString((String)schemaJsonAsString);
        if (externalSchema.has(PROPERTIES)) {
            JsonNode jsonNode = externalSchema.get(PROPERTIES);
            SchemaValidationUtils.extractFromFieldNames(jsonNode, propertySet, false);
        }
        return new ArrayList<String>(propertySet);
    }

    private static void extractFromJsonSchemaType(String businessKey, JsonNode jsonNodeValue, Set<String> propertySet, boolean isPatternPropertiesParent) {
        if (jsonNodeValue.has(PROPERTIES)) {
            SchemaValidationUtils.extractFromFieldNames(jsonNodeValue.get(PROPERTIES), propertySet, false);
            return;
        }
        if (jsonNodeValue.has(PATTERN_PROPERTIES)) {
            SchemaValidationUtils.extractFromFieldNames(jsonNodeValue.get(PATTERN_PROPERTIES), propertySet, true);
            return;
        }
        if (jsonNodeValue.has(ITEMS)) {
            SchemaValidationUtils.extractFromJsonSchemaType(businessKey, jsonNodeValue.get(ITEMS), propertySet, false);
            return;
        }
        if (!isPatternPropertiesParent) {
            propertySet.add(businessKey);
        }
    }

    private static void extractFromFieldNames(JsonNode jsonNode, Set<String> propertySet, boolean isPatternPropertiesParent) {
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String businessKey = (String)entry.getKey();
            JsonNode jsonNodeValue = (JsonNode)entry.getValue();
            SchemaValidationUtils.extractFromJsonSchemaType(businessKey, jsonNodeValue, propertySet, isPatternPropertiesParent);
        }
    }
}

