/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.iterables;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.CollectionUtils;

public abstract class BulkBufferingEntryIterator<T>
implements Iterator<T> {
    private final int bufferSize;
    private List<T> buffer;
    private int nextPos = 0;
    private boolean endOfStream = false;

    public BulkBufferingEntryIterator(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean hasNext() {
        if (this.endOfStream) {
            return false;
        }
        if (this.buffer == null) {
            this.load();
        } else if (this.nextPos >= this.buffer.size()) {
            if (this.buffer.size() < this.bufferSize) {
                this.endOfStream = true;
            } else {
                this.load();
            }
        }
        return !this.endOfStream;
    }

    private void load() {
        this.buffer = this.loadNextChunk(this.bufferSize);
        this.nextPos = 0;
        this.endOfStream = CollectionUtils.isEmpty(this.buffer);
    }

    protected abstract List<T> loadNextChunk(int var1);

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = this.buffer.get(this.nextPos);
        ++this.nextPos;
        return item;
    }
}

