/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.graph;

import fr.gouv.vitam.common.graph.DirectedGraph;
import java.util.Stack;

public class DirectedCycle {
    private final boolean[] marked;
    private final int[] edgeTo;
    private final boolean[] onStack;
    private Stack<Integer> cycle;
    private boolean isCyclic;

    public DirectedCycle(DirectedGraph graph) {
        this.marked = new boolean[graph.getVertices()];
        this.onStack = new boolean[graph.getVertices()];
        this.edgeTo = new int[graph.getVertices()];
        for (int v = 0; v < graph.getVertices(); ++v) {
            if (this.marked[v] || this.cycle != null) continue;
            this.depthFirstSearch(graph, v);
        }
    }

    private void depthFirstSearch(DirectedGraph graph, int root) {
        this.onStack[root] = true;
        this.marked[root] = true;
        for (int w : graph.adj(root)) {
            if (this.cycle != null) {
                return;
            }
            if (!this.marked[w]) {
                this.edgeTo[w] = root;
                this.depthFirstSearch(graph, w);
                continue;
            }
            if (!this.onStack[w]) continue;
            this.cycle = new Stack();
            int x = root;
            while (x != w) {
                this.cycle.push(x);
                x = this.edgeTo[x];
            }
            this.cycle.push(w);
            this.cycle.push(root);
            if (!this.check()) continue;
            this.isCyclic = true;
            return;
        }
        this.onStack[root] = false;
    }

    public boolean hasCycle() {
        return this.cycle != null;
    }

    private Iterable<Integer> cycle() {
        return this.cycle;
    }

    private boolean check() {
        if (this.hasCycle()) {
            int first = -1;
            int last = -1;
            for (int v : this.cycle()) {
                if (first == -1) {
                    first = v;
                }
                last = v;
            }
            return first == last;
        }
        return false;
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public Stack<Integer> getCycle() {
        return this.cycle;
    }
}

