/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter.strategy;

import fr.gouv.vitam.common.date.converter.DateFormatUtil;
import fr.gouv.vitam.common.date.converter.strategy.DateFormatterStrategy;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;

public class DefaultMongoFormatterStrategy
implements DateFormatterStrategy {
    @Override
    public String format(TemporalAccessor date) {
        if (date instanceof LocalDate) {
            LocalDate ld = (LocalDate)date;
            return ld.format(DateFormatUtil.ISO_DATE);
        }
        if (date instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)date;
            return ldt.getNano() > 0 ? ldt.truncatedTo(ChronoUnit.MILLIS).format(DateFormatUtil.ISO_DATE_TIME_MILLIS) : ldt.format(DateFormatUtil.ISO_DATE_TIME);
        }
        if (date instanceof OffsetDateTime) {
            OffsetDateTime odt;
            OffsetDateTime normalized = odt = (OffsetDateTime)date;
            boolean isMidnight = odt.getHour() == 0 && odt.getMinute() == 0 && odt.getSecond() == 0 && odt.getNano() == 0;
            boolean isUTC = odt.getOffset().equals(ZoneOffset.UTC);
            if (isMidnight && isUTC) {
                return odt.toLocalDate().format(DateFormatUtil.ISO_DATE);
            }
            if (odt.getNano() > 0) {
                return normalized.truncatedTo(ChronoUnit.MILLIS).format(isUTC ? DateFormatUtil.ISO_DATE_TIME_MILLIS : DateFormatUtil.ISO_DATE_TIME_OFFSET_MILLIS);
            }
            return normalized.format(isUTC ? DateFormatUtil.ISO_DATE_TIME : DateFormatUtil.ISO_DATE_TIME_OFFSET);
        }
        if (date instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)date;
            return this.format(zdt.toOffsetDateTime());
        }
        throw new IllegalArgumentException("Unsupported TemporalAccessor type: " + String.valueOf(date.getClass()));
    }
}

