/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter.resolver;

import fr.gouv.vitam.common.date.converter.resolver.DateResolver;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class ZuluMidnightResolver
implements DateResolver {
    @Override
    public boolean supports(String input) {
        return input.matches("^[+-]?\\d{4,}-\\d{2}-\\d{2}Z$");
    }

    @Override
    public TemporalAccessor resolve(String input) {
        String full = input.replace("Z", "T00:00:00Z");
        return OffsetDateTime.parse(full, DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC));
    }
}

