/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter.resolver;

import fr.gouv.vitam.common.date.converter.resolver.DateResolver;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;

public class XsdStandardDateResolver
implements DateResolver {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().parseCaseSensitive().parseStrict().appendOptional(DateTimeFormatter.ofPattern("u-MM-dd['T'HH:mm:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]XXX")).appendOptional(DateTimeFormatter.ofPattern("u/MM/dd['T'HH:mm:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]XXX")).appendOptional(DateTimeFormatter.ofPattern("u-MM-dd['T'HH:mm:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]")).appendOptional(DateTimeFormatter.ofPattern("u/MM/dd['T'HH:mm:ss[.SSSSSSSSS][.SSSSSSSS][.SSSSSSS][.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]]")).toFormatter();

    @Override
    public boolean supports(String input) {
        return true;
    }

    @Override
    public TemporalAccessor resolve(String input) {
        try {
            return FORMATTER.withResolverStyle(ResolverStyle.STRICT).parseBest(input, OffsetDateTime::from, LocalDateTime::from, LocalDate::from);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("Invalid date format: " + input, e);
        }
    }
}

