/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter.resolver;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.date.converter.resolver.DateResolver;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Map;

public class TimeZoneAbbreviationResolver
implements DateResolver {
    private static final Map<String, String> SHORT_IDS = ZoneId.SHORT_IDS;

    @Override
    public boolean supports(String input) {
        return input.matches("[^\\s]*\\s[A-Z]{2,4}$");
    }

    @Override
    public TemporalAccessor resolve(String input) {
        ZoneId zoneId;
        String[] parts = input.trim().split(" ");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid format with timezone abbreviation: " + input);
        }
        String dateTimePart = parts[0];
        String abbreviation = parts[1];
        ZoneId zoneId2 = zoneId = SHORT_IDS.containsKey(abbreviation) ? ZoneId.of(SHORT_IDS.get(abbreviation)) : ZoneId.of(abbreviation);
        if (dateTimePart.contains("T")) {
            LocalDateTime ldt = LocalDateUtil.parseMongoFormattedDate((String)dateTimePart);
            return ldt.atZone(zoneId);
        }
        LocalDate ld = LocalDate.parse(dateTimePart);
        return ld.atStartOfDay(zoneId);
    }
}

