/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.date.converter;

import fr.gouv.vitam.common.date.converter.normalizer.DateNormalizer;
import fr.gouv.vitam.common.date.converter.normalizer.TrimAndSlashNormalizer;
import fr.gouv.vitam.common.date.converter.normalizer.YearPrefixStripper;
import fr.gouv.vitam.common.date.converter.resolver.ResolverPipeline;
import fr.gouv.vitam.common.date.converter.strategy.DateFormatterStrategy;
import fr.gouv.vitam.common.date.converter.strategy.DefaultMongoFormatterStrategy;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class XsdDateToMongoConverter {
    private final List<DateNormalizer> normalizers = List.of(new YearPrefixStripper(), new TrimAndSlashNormalizer());
    private final ResolverPipeline pipeline = ResolverPipeline.builder().addTimeZoneAbbreviationResolver().addZuluMidnightResolver().addOffsetOnlyResolver().addXsdStandardResolver().build();
    private final DateFormatterStrategy formatterStrategy = new DefaultMongoFormatterStrategy();

    public String mapDateXmlToMongo(String input) {
        String normalized = input;
        for (DateNormalizer normalizer : this.normalizers) {
            if (!normalizer.supports(normalized)) continue;
            normalized = normalizer.normalize(normalized);
        }
        TemporalAccessor resolved = this.pipeline.resolve(normalized);
        return this.formatterStrategy.format(resolved);
    }
}

