/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class VitamRestTestClient
extends DefaultClient {
    public VitamRestTestClient(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    public VitamRestTest given() {
        return new VitamRestTest(this);
    }

    public static class VitamRestTest {
        final MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap();
        Object body;
        MediaType contentType;
        List<String> pathParameters = new ArrayList<String>();
        Response.Status expectedStatus;
        MediaType acceptMediaType = MediaType.APPLICATION_JSON_TYPE;
        final VitamRestTestClient client;

        VitamRestTest(VitamRestTestClient client) {
            this.client = client;
        }

        public String toString() {
            return "VitamRestTest: { " + "Headers: { " + this.headers + " } " + ", Body: { value: " + (this.body != null) + ", type: " + this.contentType + " } " + ", pathParameters: \"" + this.pathParameters + "\"" + ", expectedStatus: " + this.expectedStatus + ", acceptedMediaType: " + this.acceptMediaType + ", " + this.client.toString() + " }";
        }

        private void reset() {
            this.body = null;
            this.contentType = null;
            this.headers.clear();
            this.pathParameters.clear();
            this.expectedStatus = null;
            this.acceptMediaType = MediaType.APPLICATION_JSON_TYPE;
        }

        public VitamRestTest then() {
            return this;
        }

        public VitamRestTest when() {
            return this;
        }

        public VitamRestTest status(Response.Status status) {
            this.expectedStatus = status;
            return this;
        }

        public VitamRestTest statusCode(int statusCode) {
            this.expectedStatus = Response.Status.fromStatusCode((int)statusCode);
            return this;
        }

        public VitamRestTest accept(MediaType accept) {
            this.acceptMediaType = accept;
            return this;
        }

        public VitamRestTest body(Object body, MediaType mediaType) {
            this.body = body;
            this.contentType = mediaType;
            return this;
        }

        public VitamRestTest addHeader(String key, String value) {
            this.headers.add((Object)key, (Object)value);
            return this;
        }

        public VitamRestTest addPathParameter(String name, String value) {
            this.pathParameters.add("/" + name + "/" + value);
            return this;
        }

        private void checkStatus(int status) throws VitamClientInternalException {
            if (this.expectedStatus != null && status != this.expectedStatus.getStatusCode()) {
                throw new VitamClientInternalException(String.format("Status %d (%s) is not the one expected %d (%s)", status, Response.Status.fromStatusCode((int)status).getReasonPhrase(), this.expectedStatus.getStatusCode(), this.expectedStatus.getReasonPhrase()));
            }
        }

        private String getFinalPath(String path) {
            StringBuilder finalPath = new StringBuilder(path);
            for (String subpath : this.pathParameters) {
                finalPath.append(subpath);
            }
            return finalPath.toString();
        }

        public int execute(VitamRequestBuilder request) throws VitamClientInternalException {
            request.withHeaders(this.headers).withAccept(this.acceptMediaType);
            if (!Objects.isNull(this.contentType)) {
                request.withContentType(this.contentType);
            }
            if (!Objects.isNull(this.body)) {
                request.withBody(this.body);
            }
            try (Response response = this.client.make(request);){
                int status = response.getStatus();
                this.checkStatus(status);
                this.reset();
                int n = status;
                return n;
            }
        }

        public int get(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.get().withPath(this.getFinalPath(path)));
        }

        public int delete(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.delete().withPath(this.getFinalPath(path)));
        }

        public int head(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.head().withPath(this.getFinalPath(path)));
        }

        public int options(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.options().withPath(this.getFinalPath(path)));
        }

        public int post(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.post().withPath(this.getFinalPath(path)));
        }

        public int put(String path) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.put().withPath(this.getFinalPath(path)));
        }

        public <T> T execute(VitamRequestBuilder request, Class<T> entityTpe) throws VitamClientInternalException {
            request.withHeaders(this.headers).withAccept(this.acceptMediaType);
            if (!Objects.isNull(this.contentType)) {
                request.withContentType(this.contentType);
            }
            if (!Objects.isNull(this.body)) {
                request.withBody(this.body);
            }
            try (Response response = this.client.make(request);){
                int status = response.getStatus();
                this.checkStatus(status);
                this.reset();
                Object object = response.readEntity(entityTpe);
                return (T)object;
            }
        }

        public <T> T get(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.get().withPath(this.getFinalPath(path)), entityTpe);
        }

        public <T> T delete(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.delete().withPath(this.getFinalPath(path)), entityTpe);
        }

        public <T> T options(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.options().withPath(this.getFinalPath(path)), entityTpe);
        }

        public <T> T post(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.post().withPath(this.getFinalPath(path)), entityTpe);
        }

        public <T> T put(String path, Class<T> entityTpe) throws VitamClientInternalException {
            return this.execute(VitamRequestBuilder.put().withPath(this.getFinalPath(path)), entityTpe);
        }
    }
}

