/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.client.AbstractCommonClient;
import fr.gouv.vitam.common.client.AdminClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AdminStatusMessage;
import jakarta.ws.rs.core.Response;

public class DefaultAdminClient
extends AbstractCommonClient
implements AdminClient {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DefaultAdminClient.class);
    private final String adminUrl;

    public DefaultAdminClient(VitamClientFactoryInterface<DefaultAdminClient> factory) {
        super(factory);
        this.adminUrl = this.getUrl(factory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AdminStatusMessage adminStatus() {
        VitamRequestBuilder request = VitamRequestBuilder.get().withBaseUrl(this.adminUrl).withPath("/status").withJsonAccept().withChunckedMode(true);
        try (Response response = this.makeSpecifyingUrl(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            AdminStatusMessage message = response.hasEntity() ? (AdminStatusMessage)response.readEntity(AdminStatusMessage.class) : new AdminStatusMessage().setStatus(status == Response.Status.OK);
            if (status == Response.Status.OK || status == Response.Status.SERVICE_UNAVAILABLE) {
                AdminStatusMessage adminStatusMessage = message;
                return adminStatusMessage;
            }
            String messageText = status.getReasonPhrase() + " : " + status.getStatusCode();
            LOGGER.error(messageText);
            throw new VitamClientException(messageText);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return new AdminStatusMessage().setStatus(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VitamError<JsonNode> adminAutotest() {
        VitamError message = new VitamError("000000").setContext(StringUtils.getClassName((Object)this.getClientFactory())).setDescription(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase()).setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).setMessage(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase()).setState(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase());
        VitamRequestBuilder request = VitamRequestBuilder.get().withBaseUrl(this.adminUrl).withPath("/autotest").withJsonAccept().withChunckedMode(true);
        try (Response response = this.makeSpecifyingUrl(request);){
            Response.Status status = response.getStatusInfo().toEnum();
            if (response.hasEntity()) {
                message = VitamError.getFromJsonNode((JsonNode)JsonHandler.getFromString((String)((String)response.readEntity(String.class))));
            }
            if (status == Response.Status.OK || status == Response.Status.SERVICE_UNAVAILABLE) {
                VitamError vitamError = message;
                return vitamError;
            }
            String messageText = status.getReasonPhrase() + " : " + status.getStatusCode();
            LOGGER.error(messageText);
            throw new VitamClientException(messageText);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return message;
        }
    }

    @Override
    public String getAdminUrl() {
        return this.adminUrl;
    }

    private String getUrl(VitamClientFactoryInterface<DefaultAdminClient> factory) {
        String protocol = factory.getClientConfiguration().isSecure() ? "https" : "http";
        String host = factory.getClientConfiguration().getServerHost();
        int port = factory.getClientConfiguration().getServerPort();
        return protocol + "://" + host + ":" + port + "/admin/v1";
    }
}

