/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.OntologyOrigin;
import fr.gouv.vitam.common.model.administration.OntologyType;
import fr.gouv.vitam.common.stream.StreamUtils;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ClientMockResultHelper {
    private static final String RESULT = "{\"$query\":{},\"$hits\":{\"total\":100,\"offset\":0,\"limit\":100},\"$results\":";
    private static final String UNIT = "{\"DescriptionLevel\":\"Item\",\"Title\":[\"METADATA ENCODING AND TRANSMISSION STANDARD: PRIMER AND REFERENCE MANUAL\",\"Manuel METS revu et corrig\u00e9\"],\"Description\":[\"METSPrimerRevised.pdf\",\"Pseudo Archive METSPrimerRevised.pdf\"],\"Tag\":[\"METS\",\"norme internationale\"],\"TransactedDate\":\"2012-09-16T10:22:02\",\"Event\":[{\"EventType\":\"Cr\u00e9ation\",\"EventDateTime\":\"2010-01-01T10:22:02\"},{\"EventType\":\"Validation\",\"EventDateTime\":\"2010-02-01T10:22:02\"}],\"_uds\":[{\"aeaaaaaaaaaam7mxaa7hcakyq4z6soyaaaaq\":1}],\"#id\":\"aeaaaaaaaaaam7mxaa7hcakyq4z6spqaaaaq\",\"#nbunits\":0,\"#tenant\":0,\"#object\":\"aeaaaaaaaaaam7mxaa7hcakyq4z6sjqaaaaq\",\"#unitups\":[\"aeaaaaaaaaaam7mxaa7hcakyq4z6soyaaaaq\"],\"#min\":1,\"#max\":2,\"#allunitups\":[\"aeaaaaaaaaaam7mxaa7hcakyq4z6soyaaaaq\"],\"#operations\":[\"aedqaaaaacaam7mxabhniakyq4z4ewaaaaaq\"]}";
    public static final String UNIT_RAW = "{   \"_id\": \"aeaqaaaabufhszkyabon6albarqq7qiaaakq\",    \"DescriptionLevel\": \"Item\",    \"Title\": \"Title test\",    \"Titles\": {\"fr\": \"Title test\"},    \"Description\": \"Pseudo Archive Unit du fichier.pdf\",    \"Descriptions\": {\"fr\": \"Pseudo ArchiveE.pdf\"},    \"TransactedDate\": \"2016-09-22T12:33:02\",    \"_og\": \"aebaaaaabufhszkyabon6albarqq7qiaaala\",    \"_ops\":[\"aedqaaaaacfe6vjwab36ealbbrqw2uyaaaaq\"],    \"_opi\":\"aedqaaaaacfe6vjwab36ealbbrqw2uyaaaaq\",    \"_up\": [\"aeaqaaaaaaghay2jabzuaalbaregxuiaaaba\"],    \"_us\": [\"aeaqaaaaaaghay2jabzuaalbaregxuiaaaba\"],    \"_sp\": \"vitam\",    \"_sps\": [\"vitam\"],    \"_uds\": {\"aeaqaaaaaaghay2jabzuaalbaregxuiaaaba\": 1},    \"_min\": 1,    \"_max\": 2,    \"_tenant\": 0,    \"_v\": 1,\n    \"_storage\": {\"strategyId\": \"default\"}}";
    public static final String GOT_RAW = "{\"_id\": \"aebaaaaabufhszkyabon6albarqq7qiaaala\",    \"_profil\": \"\",    \"FileInfo\": {\"Filename\": \"jeux_test.ods\",\"LastModified\": \"2016-11-21T18:28:41.510+01:00\"},    \"_qualifiers\": [{            \"qualifier\": \"BinaryMaster\",            \"_nbc\": 1,            \"versions\": [{                    \"_id\": \"aeaaaaaaaagwky22aboqialbbrqyglqaaaaq\",                    \"DataObjectGroupId\": \"aebaaaaaaagwky22aboqialbbrqygmaaaaaq\",                    \"DataObjectVersion\": \"BinaryMaster_1\",                    \"FormatIdentification\": {\"FormatLitteral\": \"OpenDocument Spreadsheet\",\"MimeType\": \"application/vnd.oasis.opendocument.spreadsheet\",\"FormatId\": \"fmt/295\"},                    \"FileInfo\": {\"Filename\": \"jeux_test.ods\",\"LastModified\": \"2016-11-21T18:28:41.510+01:00\"},                    \"Size\": 16532,                    \"Uri\": \"Content/ID7.ods\",                    \"MessageDigest\": \"c117854cbca3e51ea94c4bd2bcf4a6756209e6c65ddbf696313e1801b2235ff33d44b2bb272e714c335a44a3b4f92d399056b94dff4dfe6b7038fa56f23b438e\",                    \"Algorithm\": \"SHA-512\",                    \"_storage\": {\"strategyId\": \"default\"}            }]    }],    \"_up\": [\"aeaqaaaabufhszkyabon6albarqq7qiaaakq\"],    \"_nbc\": 1,    \"_ops\": [\"aedqaaaaacfe6vjwab36ealbbrqw2uyaaaaq\"],    \"_sp\": \"Vitam\",    \"_sps\": [\"Vitam\"],    \"_storage\": {\"strategyId\": \"default\"},    \"_tenant\": 0,    \"_v\": 1 }";
    private static final String LOGBOOK_OPERATION = "\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"Process_SIP_unitary\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"agIdPers\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": null,\"obIdReq\": null,\"obIdIn\": null,\"events\": []}";
    private static final String LOGBOOK_LIFECYCLE = "\"evId\": \"aedqaaaaacggo2kdaamz6ak5xswm3uiaaaaq\",\"evType\": \"LFC.LFC_CREATION\",\"evDateTime\": \"2017-08-07T12:30:27.793\",\"evIdProc\": \"aedqaaaaacgcs7j2aa3oeak5xswlyaqaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"OK\",\"outDetail\": \"LFC.LFC_CREATION.OK\",\"outMessg\": \"Cr\u00e9ation du journal du cycle de vie\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"obId\": \"aeaqaaaaaaggo2kdaamz6ak5xswm3jaaaaba\",\"evDetData\": null,\"events\": []}";
    private static final String LOGBOOK_OPERATION_WITH_OBID = "\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"Process_SIP_unitary\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"obIdReq\": null,\"obIdIn\": null,\"events\": []}";
    private static final String RULE = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":\"0\", \"RuleId\":\"APP-00005\", \"RuleType\":\"AppraisalRule\", \"RuleValue\":\"Pi\u00e8ces comptables (comptable)\", \"RuleDescription\":\"Dur\u00e9e de conservation des pi\u00e8ces comptables pour le comptable l\u2019\u00e9ch\u00e9ance est calcul\u00e9e \u00e0 partir de la date de solde comptable\", \"RuleDuration\":\"6\", \"RuleMeasurement\":\"year\", \"CreationDate\":\"2016-11-02\", \"UpdateDate\":\"2016-11-02\"}";
    private static final String AGENCY = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":\"0\", \"Identifier\":\"AG-0000001\", \"Name\":\"agency\", \"Description\":\"Une description\"}";
    public static final String INGEST_CONTRACTS = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":\"0\", \"Name\":\"ArchivalAgreement0\", \"Identifier\":\"ArchivalAgreement0\", \"Description\":\"DESCRIPTION D'UN CONTRAT\", \"Status\":\"ACTIVE\", \"CreationDate\":\"2016-11-02\", \"ArchiveProfiles\":[\"FakeProfile\"], \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}";
    public static final AccessContractModel DEFAULT_ACCESS_CONTRACT = (AccessContractModel)new AccessContractModel().setWritingPermission(Boolean.valueOf(true)).setEveryDataObjectVersion(Boolean.valueOf(false)).setDataObjectVersion(Set.of("PhysicalMaster", "BinaryMaster")).setEveryOriginatingAgency(Boolean.valueOf(false)).setOriginatingAgencies(Set.of("FR_ORG_AGEC", "OriginatingAgency", "Identifier0", "Identifier1", "Identifier2", "Identifier3", "Identifier4")).setCreationDate("2016-11-02").setLastUpdate("2016-11-05").setActivationDate("2016-11-04").setDeactivationDate("2016-11-03").setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq").setIdentifier("DEFAULT_ACCESS_CONTRACT").setName("TESTS_ACCESS_CONTRACT_01").setTenant(Integer.valueOf(0)).setStatus(ActivationStatus.ACTIVE).setDescription("DESCRIPTION D'UN CONTRAT D'ACCES");
    public static final AccessContractModel ACCESS_CONTRACT_NO_DOWNLOAD = (AccessContractModel)new AccessContractModel().setWritingPermission(Boolean.valueOf(true)).setEveryDataObjectVersion(Boolean.valueOf(false)).setDataObjectVersion(Collections.emptySet()).setEveryOriginatingAgency(Boolean.valueOf(false)).setOriginatingAgencies(Set.of("FR_ORG_AGEC", "OriginatingAgency")).setCreationDate("2016-11-02").setLastUpdate("2016-11-05").setActivationDate("2016-11-04").setDeactivationDate("2016-11-03").setId("TESTS_ACCESS_CONTRACT_NO_DOWNLOAD").setIdentifier("TESTS_ACCESS_CONTRACT_NO_DOWNLOAD").setName("TESTS_ACCESS_CONTRACT_NO_DOWNLOAD").setTenant(Integer.valueOf(0)).setStatus(ActivationStatus.ACTIVE).setDescription("DESCRIPTION D'UN CONTRAT D'ACCES");
    public static final List<AccessContractModel> ACCESS_CONTRACTS = List.of(DEFAULT_ACCESS_CONTRACT, ACCESS_CONTRACT_NO_DOWNLOAD);
    public static final String MANAGEMENT_CONTRACTS = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":0, \"Name\":\"TESTS_MANAGEMENT_CONTRACT_01\", \"Description\":\"DESCRIPTION D'UN CONTRAT\", \"Status\":\"ACTIVE\", \"Storage\": {\"UnitStrategy\" : \"default\", \"ObjectGroupStrategy\": \"default\", \"ObjectStrategy\": \"default\"}, \"EveryDataObjectVersion\": false, \"CreationDate\":\"2016-11-02\", \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}";
    public static final String PROFILES = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":0, \"Identifier\":\"FAKE_IDENTIFIER\", \"Name\":\"Un Profile\", \"Description\":\"DESCRIPTION D'UN PROFILE\", \"Status\":\"ACTIVE\", \"Format\":\"XSD\", \"CreationDate\":\"2016-11-02\", \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}";
    public static final String ARCHIVE_UNIT_PROFILES = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq\", \"_tenant\":0, \"Identifier\":\"FAKE_IDENTIFIER\", \"Name\":\"Archive Unit Ptofile\", \"Description\":\"Description d'un document type\", \"Status\":\"ACTIVE\", \"CreationDate\":\"2016-11-02\", \"LastUpdate\":\"2016-11-02\", \"ActivationDate\":\"2016-11-02\", \"DeactivationDate\":\"2016-11-02\"}";
    public static final String CONTEXTS = "{\"Name\": \"My_Context_1\", \"Status\":\"ACTIVE\", \"SecurityProfile\" : \"SEC_PROFILE-000001\",\"Permissions\": [{\"_tenant\": 0,\"AccessContracts\": [],\"IngestContracts\": [\"ArchivalAgreement0\"]}]}";
    private static final String FORMAT = "{\"_id\":\"aeaaaaaaaaaaaaabaa44qakyetenaeyaaawq\", \"CreatedDate\":\"2016-01-21T10:36:46\", \"VersionPronom\":\"84\", \"Version\":\"1.12\", \"HasPriorityOverFileFormatID\":[], \"MimeType\":[], \"Name\":\"Microsoft Works Word Processor for DOS\", \"Alert\":\"false\", \"Extension\":[\"wps\"], \"PUID\":\"fmt/164\", \"_tenant\":\"0\"}";
    private static final String ACCESSION_SUMMARY = "{\"_id\": \"aefaaaaaaaaam7mxaa2gyakygejizayaaaaq\",\"_tenant\": 0,\"OriginatingAgency\": \"FRAN_NP_005568\",    \"TotalObjects\": {    \"Total\": 12,    \"Deleted\": 0,    \"Remained\": 12},\"TotalObjectGroups\": {    \"Total\": 3,    \"Deleted\": 0,    \"Remained\": 3},\"TotalUnits\": {    \"Total\": 3,    \"Deleted\": 0,    \"Remained\": 3},\"ObjectSize\": {    \"Total\": 1035126,    \"Deleted\": 0,    \"Remained\": 1035126},\"creationDate\": \"2016-11-04T20:40:49.030\"}";
    private static final String ACCESSION_DETAIL = "{\"_id\": \"aedqaaaaacaam7mxabsakakygeje2uyaaaaq\",\"_tenant\": 0,\"OriginatingAgency\": \"FRAN_NP_005568\",\"SubmissionAgency\": \"FRAN_NP_005061\",\"EndDate\": \"2016-11-04T21:40:47.912+01:00\",\"StartDate\": \"2016-11-04T21:40:47.912+01:00\",\"Status\": \"STORED_AND_COMPLETED\",\"TotalObjectGroups\": {    \"total\": 1,    \"deleted\": 0,    \"remained\": 1},\"TotalUnits\": {    \"total\": 1,    \"deleted\": 0,    \"remained\": 1},\"TotalObjects\": {    \"total\": 4,    \"deleted\": 0,    \"remained\": 4},\"ObjectSize\": {    \"total\": 345042,    \"deleted\": 0,    \"remained\": 345042}}";
    private static final String TRACEABILITY_OPERATION = "{$hint: {'total':'1'},$context:{$query: {$eq: {\"id\" : \"1\" }}, $projection: {}, $filter: {}},$result: {\"LogType\":\"OPERATION\",\"StartDate\":\"2017-03-02T12:46:25.618\",\"EndDate\":\"2017-03-02T14:22:34.811\",\"Hash\":\"obu+Z7+M7JlaY5ney0dDNTzmWr4+r6Cf3GtwMrLKpCLIL7Bjqty8kfUNSGNQ9qlzO3YE7+zRdC2o/S+uUOJM4g==\",\"TimeStampToken\":\"MIIEZzAVAgEAMBAMDk9wZXJhdGlvbiBPa2F5MIIETAYJKoZIhvcNAQcCoIIEPTCCBDkCAQMxDzANBglghkgBZQMEAgMFADCBgAYLKoZIhvcNAQkQAQSgcQRvMG0CAQEGASkwUTANBglghkgBZQMEAgMFAARAMcCUdvY+87OSgJw3slg+aHgTt+j+UcybWmhG0G9wL7A0NE8eUO8JFJRD81Gb4wTu12AealKzWeUoLczLWRhACQIBARgPMjAxNzAzMDIxNDIyMzVaMYIDnjCCA5oCAQEwTzBKMQswCQYDVQQGEwJGUjEPMA0GA1UECBMGRnJhbmNlMQ4wDAYDVQQHEwVQQXJpczENMAsGA1UEChMERXRhdDELMAkGA1UECxMCRVQCAQEwDQYJYIZIAWUDBAIDBQCgggEgMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMTcwMzAyMTQyMjM1WjAtBgkqhkiG9w0BCTQxIDAeMA0GCWCGSAFlAwQCAwUAoQ0GCSqGSIb3DQEBDQUAME8GCSqGSIb3DQEJBDFCBECDgiYpV3Bd/9ckq0Nq+zm/TmPWO3rCt33o+cKA8DI5L9EGiEV2GtjO0z4jnw08/iZ3chanYRrR8hJk4u4Fmqk4MGQGCyqGSIb3DQEJEAIvMVUwUzBRME8wCwYJYIZIAWUDBAIDBEACrDhLC92Gcm2mclJwDuLADobFbVWY5HASuT8FL0/1nNexkoSVnVclwr0VkxJgmVAxa+g8ecGbwLzDs8vbT9AYMA0GCSqGSIb3DQEBDQUABIICABBtgwv5dZJhWu050wXM27HGZF6yFaU6AOPjjUIQccbly1nw/Sebg2xRenMv+jxAm8bAdW3eBPNrSa1iJKGLmgfYZuxIwt5AluzVuvTH2t1j08XSMmDQpilhN6Bx9dOS3aClNm89ZVygmdUz6N9HGmxZh1yis80SxD6jDjhnuK6R+xpmdmL6HIDzHa5mjOCbD1lXtr5tWWR+1K9Axv4qoLADlrUKmpCdbnfUBgVdbWJnJBcW6WoQXDpTD/JbV/m2s/yzK7FDt+IpERwVZGqiZF9WwzgX9AFJ352tFWWj+KhqfFN8UgfPKD5aCo6V5T+vMlkodiV+0XQBPKdcPBoo8PJtiCR5sFlJHbQ0qGwQq6P/06ApvrXOFKz434CkCGTbZLKVEHTs1SqgZuAg54bR6GbifOheVojOhWDFEMEXlnpD7PjCYscL9U83H92Iosr4rJhvYwSYbahmU7W1RlUP4cHy8nUYwvUO54ehYMcKcZ4idG4nbUfVYy8lClYruKG0rVcwWu3TZxeSaLePYRZwaeXJ00p36SttyZTLeN4rZatePQc/ff856jvKqDlDZlXIyhOcYCXot5xHFlv+zKZhB71uOv/XvqqmZFhentmkZFYK+qi2tH+Tahar2f3b4RJo+bm235g/v1rIvKQKe8rjkemgPIG7RzkCnss2SGIpfW5h\",\"NumberOfElements\":4,\"FileName\":\"0_LogbookOperation_20170302_142234.zip\",\"Size\":41807}}";
    private static final String TRACEABILITY_LOGBOOK_OPERATION = "{\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"CHECK_TRACEABILITY_OPERATION\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"TRACEABILITY\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"storage\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": null,\"obIdReq\": null,\"obIdIn\": null,\"events\": [{\"evTypeProc\": \"TRACEABILITY\",\"evDetData\": {\"LogType\":\"OPERATION\",\"StartDate\":\"2017-04-06T22:50:59.657\",\"EndDate\":\"2017-04-06T23:01:03.121\",\"Hash\":\"HASH_TEST\",\"TimeStampToken\":\"TimeStamp_TEST\",\"NumberOfElements\":4,\"FileName\":\"0_LogbookOperation_20170406_230103.zip\",\"Size\":4141}}]}";
    public static final String SECURITY_PROFILES = "{\"_id\":\"aeaaaaaaaaaaaaabaa4ikakyetcaaaabbbcc\",\"Identifier\": \"SEC_PROFILE-000001\",\"Name\": \"TEST_PROFILE_1\",\"FullAccess\": false,\"Permissions\": [\"permission_one:read\",\"permission_one:id:write\"]}";
    public static final List<OntologyModel> ONTOLOGIES = Collections.singletonList(new OntologyModel().setId("aeaaaaaaaaaaaaabaa4ikakyetch6mqaaacq").setIdentifier("_sps").setId("aeaaaaaaaaaaaaabaa4ikakyetcaaaabbbcc").setTenant(Integer.valueOf(1)).setIdentifier("_sps").setApiField("#originating_agencies").setSedaField("OriginatingAgencyIdentifier").setDescription("Internal ontology sample").setOrigin(OntologyOrigin.INTERNAL).setShortName("Originating Agency Identifier").setCollections(Arrays.asList("Unit", "ObjectGroup")).setType(OntologyType.KEYWORD));
    private static List<OntologyModel> ontologies = ONTOLOGIES;
    private static final String DIP_RESULTS = "{}";

    private ClientMockResultHelper() {
    }

    public static JsonNode getLogbookResults() throws InvalidParseOperationException {
        StringBuilder result = new StringBuilder(RESULT).append("[");
        for (int i = 0; i < 100; ++i) {
            result.append("{\"_id\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaa").append(i).append("\",").append(LOGBOOK_OPERATION);
            if (i >= 99) continue;
            result.append(",");
        }
        result.append("]}");
        return JsonHandler.getFromString((String)result.toString());
    }

    public static RequestResponse getLogbooksRequestResponse() throws InvalidParseOperationException {
        return RequestResponseOK.getFromJsonNode((JsonNode)ClientMockResultHelper.getLogbookResults());
    }

    public static RequestResponse getLogbookRequestResponse() throws InvalidParseOperationException {
        return RequestResponseOK.getFromJsonNode((JsonNode)ClientMockResultHelper.getLogbookOperation());
    }

    public static RequestResponse getLogbookRequestResponseWithObId() throws InvalidParseOperationException {
        return RequestResponseOK.getFromJsonNode((JsonNode)ClientMockResultHelper.getLogbookOperationWithObId());
    }

    public static JsonNode getLogbookOperation() throws InvalidParseOperationException {
        return JsonHandler.getFromString((String)"{\"$query\":{},\"$hits\":{\"total\":100,\"offset\":0,\"limit\":100},\"$results\":[{\"_id\": \"aeaqaaaaaefex4j4aao2qalmjv7h24yaaaaq\",\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"Process_SIP_unitary\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"agIdPers\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": null,\"obIdReq\": null,\"obIdIn\": null,\"events\": []}]}");
    }

    public static JsonNode getLogbookLifecycle() throws InvalidParseOperationException {
        return JsonHandler.getFromString((String)"{\"$query\":{},\"$hits\":{\"total\":100,\"offset\":0,\"limit\":100},\"$results\":[{\"_id\": \"aeaqaaaaaefex4j4aao2qalmjv7h24yaaaaq\",\"evId\": \"aedqaaaaacggo2kdaamz6ak5xswm3uiaaaaq\",\"evType\": \"LFC.LFC_CREATION\",\"evDateTime\": \"2017-08-07T12:30:27.793\",\"evIdProc\": \"aedqaaaaacgcs7j2aa3oeak5xswlyaqaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"OK\",\"outDetail\": \"LFC.LFC_CREATION.OK\",\"outMessg\": \"Cr\u00e9ation du journal du cycle de vie\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"obId\": \"aeaqaaaaaaggo2kdaamz6ak5xswm3jaaaaba\",\"evDetData\": null,\"events\": []}]}");
    }

    public static RequestResponse<JsonNode> getMetaDataResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.getArchiveUnitResult();
    }

    public static RequestResponse<JsonNode> getArchiveUnitRawResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(UNIT_RAW);
    }

    public static RequestResponse<JsonNode> getObjectGroupRawResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(GOT_RAW);
    }

    public static JsonNode getLogbookOperationWithObId() throws InvalidParseOperationException {
        return JsonHandler.getFromString((String)"{\"$query\":{},\"$hits\":{\"total\":100,\"offset\":0,\"limit\":100},\"$results\":[{\"_id\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaa1\",\"evId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsqaaaaq\",\"evType\": \"Process_SIP_unitary\",\"evDateTime\": \"2016-06-10T11:56:35.914\",\"evIdProc\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"evTypeProc\": \"INGEST\",\"outcome\": \"STARTED\",\"outDetail\": null,\"outMessg\": \"SIP entry : SIP.zip\",\"agId\": \"{\\\"Name\\\":\\\"vitam-iaas-app-01\\\",\\\"Role\\\":\\\"ingest-external\\\",\\\"ServerId\\\":1048375580,\\\"SiteId\\\":1,\\\"GlobalPlatformId\\\":243069212}\",\"agIdApp\": null,\"evIdAppSession\": null,\"evIdReq\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"agIdExt\": null,\"obId\": \"aedqaaaaacaam7mxaaaamakvhiv4rsiaaaaq\",\"obIdReq\": null,\"obIdIn\": null,\"events\": []}]}");
    }

    public static <T> RequestResponse<T> createResponse(T response) {
        return new RequestResponseOK().addResult(response);
    }

    public static RequestResponse createEmptyReponse() {
        return new RequestResponseOK();
    }

    public static RequestResponse createVitamError() {
        return new VitamError("Fake");
    }

    public static RequestResponse createResponse(String s) throws InvalidParseOperationException {
        RequestResponseOK responseOK = new RequestResponseOK();
        if (null != s) {
            responseOK.addResult((Object)JsonHandler.getFromString((String)s));
        }
        return responseOK.setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static <T> RequestResponse<T> createResponse(String s, Class<T> clasz) throws InvalidParseOperationException {
        RequestResponseOK responseOK = new RequestResponseOK();
        if (null != s) {
            responseOK.addResult(JsonHandler.getFromString((String)s, clasz));
        }
        return responseOK.setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static <T> RequestResponse<T> createResponse(List<T> entries) throws InvalidParseOperationException {
        RequestResponseOK responseOK = new RequestResponseOK();
        responseOK.addAllResults(entries);
        return responseOK.setHttpCode(Response.Status.OK.getStatusCode());
    }

    public static RequestResponse createResponse(String s, int statuscode, Class clazz) throws InvalidParseOperationException {
        RequestResponseOK responseOK = new RequestResponseOK();
        if (null != s) {
            responseOK.addResult(JsonHandler.getFromString((String)s, (Class)clazz));
        }
        return responseOK.setHttpCode(statuscode);
    }

    public static RequestResponse getAccessionRegisterSummary() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(ACCESSION_SUMMARY);
    }

    public static RequestResponse getAccessionRegisterDetail() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(ACCESSION_DETAIL);
    }

    public static RequestResponse getFormat() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(FORMAT);
    }

    public static RequestResponse getRule() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(RULE);
    }

    public static RequestResponse getAgency() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(AGENCY);
    }

    public static RequestResponse<IngestContractModel> getIngestContracts() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(INGEST_CONTRACTS, IngestContractModel.class);
    }

    public static RequestResponse getAccessContractOrDefault(String identifier) throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(ACCESS_CONTRACTS.stream().filter(ac -> StringUtils.equals((CharSequence)ac.getIdentifier(), (CharSequence)identifier)).findFirst().orElse(DEFAULT_ACCESS_CONTRACT));
    }

    public static RequestResponse getManagementContracts() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(MANAGEMENT_CONTRACTS);
    }

    public static RequestResponse getContexts(int statusCode) throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(CONTEXTS, statusCode, ContextModel.class);
    }

    public static RequestResponse getProfiles(int statusCode) throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(PROFILES, statusCode, ObjectNode.class);
    }

    public static RequestResponse getFormatList() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(FORMAT);
    }

    public static RequestResponse getAgenciesList() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(AGENCY);
    }

    public static RequestResponse getRuleList(String ruleId) throws InvalidParseOperationException {
        ObjectNode rule = (ObjectNode)JsonHandler.getFromString((String)RULE);
        String oldRuleId = rule.get("RuleId").asText();
        rule.put("RuleId", ruleId);
        switch (ruleId.substring(0, 3)) {
            case "STO": {
                rule.put("RuleType", "StorageRule");
                break;
            }
            case "CLA": {
                rule.put("RuleType", "ClassificationRule");
                break;
            }
            case "ACC": {
                rule.put("RuleType", "AccessRule");
                break;
            }
            case "APP": {
                rule.put("RuleType", "AppraisalRule");
                break;
            }
            case "DIS": {
                rule.put("RuleType", "DisseminationRule");
                break;
            }
            case "REU": {
                rule.put("RuleType", "ReuseRule");
                break;
            }
            default: {
                rule.put("RuleId", oldRuleId);
            }
        }
        return ClientMockResultHelper.createResponse(rule);
    }

    public static RequestResponse getRuleList() throws InvalidParseOperationException {
        ObjectNode rule = (ObjectNode)JsonHandler.getFromString((String)RULE);
        return ClientMockResultHelper.createResponse(rule);
    }

    public static RequestResponse getEmptyResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse("{\"$query\":{},\"$hits\":{\"total\":100,\"offset\":0,\"limit\":100},\"$results\":{}}");
    }

    public static RequestResponse getArchiveUnitResult() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(UNIT);
    }

    public static Response getObjectStream() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Disposition", (Object)"filename=\"test.txt\"");
        return new AbstractMockClient.FakeInboundResponse(Response.Status.OK, StreamUtils.toInputStream((String)"test"), MediaType.APPLICATION_OCTET_STREAM_TYPE, (MultivaluedHashMap<String, Object>)headers);
    }

    public static ItemStatus getItemStatus(String id) throws InvalidParseOperationException {
        return new ItemStatus(id);
    }

    public static RequestResponse getOperationTraceabilityDetails() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(TRACEABILITY_OPERATION);
    }

    public static RequestResponse checkOperationTraceability() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(TRACEABILITY_OPERATION);
    }

    public static RequestResponse getTraceabilityOperationMock() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(TRACEABILITY_LOGBOOK_OPERATION);
    }

    public static RequestResponse getSecurityProfiles() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(SECURITY_PROFILES);
    }

    public static RequestResponse getDipInfo() throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(DIP_RESULTS);
    }

    public static RequestResponse getArchiveUnitProfiles(int statusCode) throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(ARCHIVE_UNIT_PROFILES);
    }

    public static RequestResponse getOntologies(int statusCode) throws InvalidParseOperationException {
        return ClientMockResultHelper.createResponse(ontologies);
    }

    public static void setOntologies(List<OntologyModel> ontologies) {
        ClientMockResultHelper.ontologies = ontologies;
    }

    public static void resetOntologies() {
        ontologies = ONTOLOGIES;
    }
}

