/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.web.filter;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shiro.lang.ShiroException;

public class CertUtils {
    public static final String REQUEST_PERSONAL_CERTIFICATE_ATTRIBUTE = "Personae";
    public static final String JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    private static final String NGINX_URL_ENCODED_PEM_HEADER_SIGNATURE = "-----BEGIN%20CERTIFICATE-----";
    private static final String BEGIN_CERT_PREFIX = "-----BEGIN";
    private static final String END_CERT_PREFIX = "-----END";
    private static final String NULL_HTTPD_HEADER = "(null)";
    private static final AlertService alertService = new AlertServiceImpl();

    public static X509Certificate[] extractCert(ServletRequest request, boolean useHeader) {
        Object[] clientCertChain;
        Object attribute = request.getAttribute(JAVAX_SERVLET_REQUEST_X_509_CERTIFICATE);
        Object[] objectArray = clientCertChain = null == attribute ? null : (X509Certificate[])attribute;
        if (ArrayUtils.isNotEmpty((Object[])clientCertChain)) {
            return clientCertChain;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String pem = httpRequest.getHeader("X-SSL-CLIENT-CERT");
        if (null != pem && !NULL_HTTPD_HEADER.equals(pem)) {
            if (!useHeader) {
                alertService.createAlert("SEVERE. Illegal access with X-SSL-CLIENT-CERT header. Forged header attack?");
                return null;
            }
            try {
                pem = CertUtils.hasNginxSignature(pem) ? CertUtils.extractNginxEncodedCertificateAsPEM(pem) : CertUtils.extractHttpdEncodedCertificateAsPEM(pem);
                ByteArrayInputStream pemStream = new ByteArrayInputStream(pem.getBytes());
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(pemStream);
                return new X509Certificate[]{cert};
            }
            catch (Exception ce) {
                alertService.createAlert("Could not read certificate" + ce.getMessage());
                throw new ShiroException((Throwable)ce);
            }
        }
        return null;
    }

    private static boolean hasNginxSignature(String pem) {
        return pem.startsWith(NGINX_URL_ENCODED_PEM_HEADER_SIGNATURE);
    }

    private static String extractNginxEncodedCertificateAsPEM(String pem) {
        pem = URLDecoder.decode(pem, StandardCharsets.UTF_8);
        return pem;
    }

    private static String extractHttpdEncodedCertificateAsPEM(String pem) {
        StringTokenizer stringTokenizer = new StringTokenizer(pem, " ", false);
        StringBuilder stringBuilder = new StringBuilder(pem.length());
        block7: while (stringTokenizer.hasMoreTokens()) {
            String token;
            switch (token = stringTokenizer.nextToken()) {
                case "-----BEGIN": 
                case "-----END": {
                    stringBuilder.append(token).append(' ');
                    continue block7;
                }
            }
            stringBuilder.append(token).append('\n');
        }
        pem = stringBuilder.toString();
        return pem;
    }
}

