/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.core.realm;

import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationInfo;
import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationToken;
import fr.gouv.vitam.common.auth.core.realm.AbstractX509Realm;
import fr.gouv.vitam.common.auth.core.realm.RealmUtils;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;

public class X509KeystoreFileWithRoleRealm
extends AbstractX509Realm {
    private static final String REALM_NAME = "X509KeystoreFile";
    private final Set<X509Certificate> grantedIssuers = new HashSet<X509Certificate>();
    private Map<String, String> roleDefs = RealmUtils.getRoleDefs();
    private Map<String, String> certificateDnRoleMapping;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String username = (String)this.getAvailablePrincipal(principals);
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        if (this.certificateDnRoleMapping != null && this.certificateDnRoleMapping.get(username) != null) {
            roleNames.add(this.certificateDnRoleMapping.get(username));
        }
        SimpleAuthorizationInfo authInfo = new SimpleAuthorizationInfo(roleNames);
        Set<Permission> permissionsSet = RealmUtils.getPermissionsSet(this.roleDefs, roleNames);
        authInfo.setObjectPermissions(permissionsSet);
        return authInfo;
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof X509AuthenticationToken;
    }

    public Class<X509AuthenticationToken> getAuthenticationTokenClass() {
        return X509AuthenticationToken.class;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        return this.doGetX509AuthenticationInfo((X509AuthenticationToken)token);
    }

    @Override
    protected X509AuthenticationInfo doGetX509AuthenticationInfo(X509AuthenticationToken x509AuthenticationToken) {
        X509AuthenticationInfo x509AuthenticationInfo = RealmUtils.getX509AuthenticationInfo(x509AuthenticationToken, this.getGrantedKeyStoreName(), this.getGrantedKeyStorePassphrase(), this.getTrustedKeyStoreName(), this.getTrustedKeyStorePassphrase(), this.grantedIssuers, REALM_NAME);
        if (x509AuthenticationInfo != null) {
            this.assertCredentialsMatch(x509AuthenticationToken, (AuthenticationInfo)x509AuthenticationInfo);
        }
        return x509AuthenticationInfo;
    }

    public Map<String, String> getCertificateDnRoleMapping() {
        return this.certificateDnRoleMapping;
    }

    public void setCertificateDnRoleMapping(Map<String, String> certificateDnRoleMapping) {
        this.certificateDnRoleMapping = certificateDnRoleMapping;
    }
}

