/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.auth.core.realm;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationInfo;
import fr.gouv.vitam.common.auth.core.authc.X509AuthenticationToken;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.PermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;
import org.apache.shiro.config.Ini;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.util.PermissionUtils;

class RealmUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RealmUtils.class);
    private static final String ROLES_SECTION_NAME = "roles";
    private static final String SHIRO_INI_FILE = "shiro.ini";

    RealmUtils() {
    }

    static Map<String, String> getRoleDefs() {
        try {
            IniRealm inirealm = new IniRealm(PropertiesUtils.findFile((String)SHIRO_INI_FILE).getPath());
            Ini iniConf = inirealm.getIni();
            if (iniConf != null) {
                return inirealm.getIni().getSection(ROLES_SECTION_NAME);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Shiro.ini file not found. You should use shiro.ini file to declare role");
        }
        return Collections.emptyMap();
    }

    static Set<Permission> getPermissionsSet(Map<String, String> roleDefs, Set<String> roleNames) {
        WildcardPermissionResolver wpResolver = new WildcardPermissionResolver();
        HashSet<Permission> permissionsSet = new HashSet<Permission>();
        if (roleDefs != null) {
            for (String role : roleNames) {
                String permissions = roleDefs.get(role);
                if (permissions == null) continue;
                permissionsSet.addAll(PermissionUtils.resolveDelimitedPermissions((String)permissions, (PermissionResolver)wpResolver));
            }
        }
        return permissionsSet;
    }

    static X509AuthenticationInfo getX509AuthenticationInfo(X509AuthenticationToken x509AuthenticationToken, String grantedKeyStoreName, String grantedKeyStorePassphrase, String trustedKeyStoreName, String trustedKeyStorePassphrase, Set<X509Certificate> grantedIssuers, String realmName) {
        X509AuthenticationInfo x509AuthenticationInfo;
        block8: {
            x509AuthenticationInfo = null;
            try {
                KeyStore grantedks;
                ParametersChecker.checkParameter((String)grantedKeyStorePassphrase, (String[])new String[]{"grantedKeyStorePassphrase cannot be null"});
                ParametersChecker.checkParameter((String)trustedKeyStorePassphrase, (String[])new String[]{"trustedKeyStorePassphrase cannot be null"});
                KeyStore trustedks = RealmUtils.readAndLoadKeystore(trustedKeyStoreName, trustedKeyStorePassphrase);
                if (trustedks != null) {
                    Enumeration<String> e = trustedks.aliases();
                    while (e.hasMoreElements()) {
                        String alias = e.nextElement();
                        grantedIssuers.add((X509Certificate)trustedks.getCertificate(alias));
                    }
                }
                if ((grantedks = RealmUtils.readAndLoadKeystore(grantedKeyStoreName, grantedKeyStorePassphrase)) == null) break block8;
                Enumeration<String> e = grantedks.aliases();
                while (e.hasMoreElements()) {
                    String alias = e.nextElement();
                    X509Certificate x509cert = (X509Certificate)grantedks.getCertificate(alias);
                    if (!new Sha256Hash((Object)x509cert.getEncoded()).equals((Object)new Sha256Hash((Object)x509AuthenticationToken.getX509Certificate().getEncoded()))) continue;
                    x509AuthenticationInfo = new X509AuthenticationInfo((Object)x509AuthenticationToken.getSubjectDN().getName(), x509AuthenticationToken.getX509Certificate(), grantedIssuers, realmName);
                    break;
                }
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("Unable to verify the integrity of the keystore", (Throwable)e);
            }
            catch (CertificateException e) {
                LOGGER.error("Unable to load a certificate of the keystore", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Unable to open the keystore", (Throwable)e);
            }
            catch (KeyStoreException e) {
                LOGGER.error("The keystore type has not been loaded", (Throwable)e);
            }
        }
        return x509AuthenticationInfo;
    }

    private static KeyStore readAndLoadKeystore(String filename, String passphrase) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        File f = PropertiesUtils.findFile((String)filename);
        FileInputStream fis = new FileInputStream(f);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(fis, passphrase.toCharArray());
            keyStore = ks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Keystore Not found : " + filename, (Throwable)e);
                return null;
            }
        }
        fis.close();
        return keyStore;
    }
}

