/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientIllegalOperationException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientNotFoundException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientServerException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.ExpectationFailedClientException;
import fr.gouv.vitam.common.exception.ForbiddenClientException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.NoWritingPermissionException;
import fr.gouv.vitam.common.exception.PreconditionFailedClientException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.massupdate.MassUpdateUnitRuleRequest;
import fr.gouv.vitam.common.model.revertupdate.RevertUpdateOptions;
import fr.gouv.vitam.common.model.storage.AccessRequestReference;
import fr.gouv.vitam.common.model.storage.StatusByAccessRequest;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

class AccessInternalClientRest
extends DefaultClient
implements AccessInternalClient {
    private static final String INVALID_PARSE_OPERATION = "Invalid Parse Operation";
    private static final String FORBIDDEN_OPERATION = "Empty query cannot be executed";
    private static final String REQUEST_PRECONDITION_FAILED = "Request precondition failed";
    private static final String NOT_FOUND_EXCEPTION = "Element not found";
    private static final String ACCESS_CONTRACT_EXCEPTION = "Access by Contract Exception";
    private static final String NO_WRITING_PERMISSION = "No Writing Permission";
    private static final String BLANK_DSL = "select DSL is blank";
    private static final String BLANK_UNIT_ID = "unit identifier should be filled";
    private static final String BLANK_OBJECT_ID = "object identifier should be filled";
    private static final String BLANK_OBJECT_GROUP_ID = "object identifier should be filled";
    private static final String BLANK_TRACEABILITY_OPERATION_ID = "traceability operation identifier should be filled";
    private static final String LOGBOOK_OPERATIONS_URL = "/operations";
    private static final String LOGBOOK_UNIT_LIFECYCLE_URL = "/unitlifecycles";
    private static final String LOGBOOK_OBJECT_LIFECYCLE_URL = "/objectgrouplifecycles";
    private static final String LOGBOOK_LINKED_CHECK = "/traceability/linkedcheck";
    private static final String OBJECTS = "objects/";
    private static final String DIPEXPORT = "dipexport/";
    private static final String EXPORT_BY_USAGE_FILTER = "export/usagefilter";
    private static final String TRANSFER_EXPORT = "transferexport/";
    private static final String UNITS = "units/";
    private static final String UNIT_PERSISTENT_IDENTIFIER = "unitpid/";
    private static final String OBJECT_PERSISTENT_IDENTIFIER = "objectpid/";
    private static final String UNITS_ATOMIC_BULK = "units/atomicbulk/";
    private static final String UNITS_RULES = "/units/rules";
    private static final String UNITS_WITH_INHERITED_RULES = "unitsWithInheritedRules";
    private static final String UNITS_STREAM = "/units/stream";
    private static final String OBJECTS_STREAM = "/objects/stream";
    private static final Runnable CHECK_REQUEST_ID = () -> VitamThreadUtils.getVitamSession().checkValidRequestId();

    AccessInternalClientRest(AccessInternalClientFactory factory) {
        super((VitamClientFactoryInterface)factory);
    }

    @Override
    public RequestResponse<JsonNode> selectUnits(JsonNode selectQuery) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException {
        RequestResponse requestResponse;
        block13: {
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(UNITS).withBody((Object)selectQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block13;
            }
            catch (BadRequestException e) {
                VitamError vitamError;
                block14: {
                    try {
                        vitamError = RequestResponse.parseVitamError((Response)response);
                        if (response == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ExpectationFailedClientException | PreconditionFailedClientException | VitamClientInternalException e2) {
                            throw new AccessInternalClientServerException(e2);
                        }
                        catch (ForbiddenClientException e3) {
                            throw new BadRequestException((Throwable)e3);
                        }
                        catch (NoWritingPermissionException e4) {
                            throw new InvalidParseOperationException((Throwable)e4);
                        }
                    }
                    response.close();
                }
                return vitamError;
            }
            response.close();
        }
        return requestResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response selectUnitsByUnitPersistentIdentifier(String persistentIdentifier, JsonNode selectQuery) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException {
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("units/unitpid/" + persistentIdentifier).withBody((Object)selectQuery, BLANK_DSL).withJson());
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (ExpectationFailedClientException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
        catch (ForbiddenClientException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (NoWritingPermissionException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
        catch (BadRequestException e) {
            Response response3 = RequestResponse.parseVitamError(response).toResponse();
            return response3;
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RequestResponse<JsonNode> selectObjectsByObjectPersistentIdentifier(String persistentIdentifier, JsonNode selectQuery) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException {
        try {
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("objects/objectpid/" + persistentIdentifier).withBody((Object)selectQuery, BLANK_DSL).withJson());
            try {
                try {
                    this.check(response);
                }
                catch (BadRequestException e) {
                    VitamError vitamError = RequestResponse.parseVitamError((Response)response);
                    if (response == null) return vitamError;
                    response.close();
                    return vitamError;
                }
                RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response);
                return requestResponse;
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable;
                        throwable.addSuppressed(throwable2);
                    }
                }
            }
        }
        catch (ExpectationFailedClientException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
        catch (ForbiddenClientException e) {
            throw new BadRequestException((Throwable)e);
        }
        catch (NoWritingPermissionException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
    }

    @Override
    public Response streamUnits(JsonNode selectQuery) throws AccessInternalClientServerException, ExpectationFailedClientException, AccessUnauthorizedException {
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(UNITS_STREAM).withBody((Object)selectQuery, BLANK_DSL).withJsonContentType().withOctetAccept());
            Response.Status status = response.getStatusInfo().toEnum();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                switch (status) {
                    case EXPECTATION_FAILED: {
                        throw new ExpectationFailedClientException(REQUEST_PRECONDITION_FAILED);
                    }
                    case UNAUTHORIZED: {
                        throw new AccessUnauthorizedException(status.toString());
                    }
                }
                throw new AccessInternalClientServerException(status.toString());
            }
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new AccessInternalClientServerException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response streamObjects(JsonNode selectQuery) throws AccessInternalClientServerException, ExpectationFailedClientException, AccessUnauthorizedException {
        Response response = null;
        try {
            VitamRequestBuilder request = VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(OBJECTS_STREAM).withBody((Object)selectQuery, BLANK_DSL).withJsonContentType().withOctetAccept();
            response = this.make(request);
            Response.Status status = response.getStatusInfo().toEnum();
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
                switch (status) {
                    case EXPECTATION_FAILED: {
                        throw new ExpectationFailedClientException(REQUEST_PRECONDITION_FAILED);
                    }
                    case UNAUTHORIZED: {
                        throw new AccessUnauthorizedException(status.toString());
                    }
                }
                throw new AccessInternalClientServerException(status.toString());
            }
            Response response2 = response;
            return response2;
        }
        catch (VitamClientInternalException e) {
            throw new AccessInternalClientServerException((Throwable)e);
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<JsonNode> selectUnitbyId(JsonNode selectQuery, String idUnit) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)BLANK_UNIT_ID, (String[])new String[]{idUnit});
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(UNITS + idUnit).withBody((Object)selectQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> updateUnitbyId(JsonNode updateQuery, String unitId) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, NoWritingPermissionException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block11: {
            ParametersChecker.checkParameter((String)BLANK_UNIT_ID, (String[])new String[]{unitId});
            Response response = this.make(VitamRequestBuilder.put().withBefore(CHECK_REQUEST_ID).withPath(UNITS + unitId).withBody((Object)updateQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block11;
            }
            catch (BadRequestException e) {
                VitamError vitamError;
                block12: {
                    try {
                        vitamError = RequestResponse.parseVitamError((Response)response);
                        if (response == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ExpectationFailedClientException | ForbiddenClientException | PreconditionFailedClientException | VitamClientInternalException e2) {
                            throw new AccessInternalClientServerException(e2);
                        }
                    }
                    response.close();
                }
                return vitamError;
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> updateUnits(JsonNode updateQuery) throws InvalidParseOperationException, AccessInternalClientServerException, NoWritingPermissionException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block11: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath(UNITS).withBody((Object)updateQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block11;
            }
            catch (BadRequestException e) {
                VitamError vitamError;
                block12: {
                    try {
                        vitamError = RequestResponse.parseVitamError((Response)response);
                        if (response == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (AccessInternalClientNotFoundException | ExpectationFailedClientException | ForbiddenClientException | PreconditionFailedClientException | VitamClientInternalException e2) {
                            throw new AccessInternalClientServerException(e2);
                        }
                    }
                    response.close();
                }
                return vitamError;
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> updateUnitsRules(MassUpdateUnitRuleRequest massUpdateUnitRuleRequest) throws InvalidParseOperationException, AccessInternalClientServerException, NoWritingPermissionException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block9: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath(UNITS_RULES).withBody((Object)massUpdateUnitRuleRequest, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException(INVALID_PARSE_OPERATION);
                }
                catch (AccessInternalClientNotFoundException | ExpectationFailedClientException | ForbiddenClientException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> bulkAtomicUpdateUnits(JsonNode updateQueries) throws InvalidParseOperationException, AccessInternalClientServerException, NoWritingPermissionException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block11: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath(UNITS_ATOMIC_BULK).withBody((Object)updateQueries, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block11;
            }
            catch (BadRequestException e) {
                VitamError vitamError;
                block12: {
                    try {
                        vitamError = RequestResponse.parseVitamError((Response)response);
                        if (response == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (AccessInternalClientNotFoundException | ExpectationFailedClientException | ForbiddenClientException | PreconditionFailedClientException | VitamClientInternalException e2) {
                            throw new AccessInternalClientServerException(e2);
                        }
                    }
                    response.close();
                }
                return vitamError;
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> selectObjectbyId(JsonNode selectObjectQuery, String objectId) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block10: {
            ParametersChecker.checkParameter((String)"object identifier should be filled", (String[])new String[]{objectId});
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(OBJECTS + objectId).withBody((Object)selectObjectQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PreconditionFailedClientException e) {
                    throw new IllegalArgumentException(Response.Status.PRECONDITION_FAILED.name());
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException(INVALID_PARSE_OPERATION);
                }
                catch (ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response getObject(String objectGroupId, String usage, int version, String unitId) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, AccessInternalClientUnavailableDataFromAsyncOfferException {
        ParametersChecker.checkParameter((String)"object identifier should be filled", (String[])new String[]{objectGroupId});
        ParametersChecker.checkParameter((String)BLANK_UNIT_ID, (String[])new String[]{unitId});
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(OBJECTS + objectGroupId + "/" + unitId).withHeader("X-Qualifier", (Object)usage).withHeader("X-Version", (Object)version).withJsonOctet().withBefore(CHECK_REQUEST_ID);
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(request);
            if (response.getStatus() == CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER.getStatusCode()) {
                throw new AccessInternalClientUnavailableDataFromAsyncOfferException("Access to async offer requires valid access request");
            }
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (PreconditionFailedClientException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
        catch (BadRequestException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response downloadObjectByPersistentIdentifier(String persistentIdentifier) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Persistent identifier must not be blank or defined", (String[])new String[]{persistentIdentifier});
        String path = String.format("objects/objectpid/%s", persistentIdentifier);
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(path).withJson());
            try {
                this.check(response);
            }
            catch (AccessInternalClientNotFoundException | AccessUnauthorizedException throwable) {
                // empty catch block
            }
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (VitamException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public Response downloadObjectsByUnitPersistentIdentifier(String unitPersistentIdentifier, String qualifier, Integer version) throws VitamClientException {
        ParametersChecker.checkParameter((String)"Persistent identifier must not be blank or defined", (String[])new String[]{unitPersistentIdentifier});
        Response response = null;
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (qualifier != null) {
                queryParams.put("qualifier", qualifier);
            }
            if (version != null) {
                queryParams.put("version", String.valueOf(version));
            }
            if ((response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("objects/unitpid/" + unitPersistentIdentifier).withQueryParams(queryParams).withJson())).getStatusInfo().toEnum() == Response.Status.NOT_FOUND) {
                Response response2 = response;
                return response2;
            }
            this.check(response);
            Response response3 = response;
            return response3;
        }
        catch (VitamException e) {
            throw new VitamClientException((Throwable)e);
        }
        finally {
            if (response != null && !Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily()) && response.getStatusInfo().toEnum() != Response.Status.NOT_FOUND) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<JsonNode> selectOperation(JsonNode select, boolean isSliced, boolean isCrossTenant) throws LogbookClientException, InvalidParseOperationException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block11: {
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath(LOGBOOK_OPERATIONS_URL).withBody((Object)select, "Select cannot be empty or null.").withJson();
            if (isSliced) {
                request.withHeader("X-Sliced-Operations", (Object)true);
            }
            if (isCrossTenant) {
                request.withHeader("X-Cross-Tenant", (Object)true);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (AccessInternalClientNotFoundException | AccessInternalClientServerException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> selectOperationById(String processId, JsonNode select, boolean isSliced, boolean isCrossTenant) throws LogbookClientException, InvalidParseOperationException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block12: {
            ParametersChecker.checkParameter((String)"processId cannot be blank.", (String[])new String[]{processId});
            VitamRequestBuilder request = VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("/operations/" + processId).withBody((Object)select, "Select cannot be empty or null.").withJson();
            if (isSliced) {
                request.withHeader("X-Sliced-Operations", (Object)true);
            }
            if (isCrossTenant) {
                request.withHeader("X-Cross-Tenant", (Object)true);
            }
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (AccessInternalClientNotFoundException e) {
                    throw new LogbookClientNotFoundException((Throwable)e);
                }
                catch (AccessInternalClientServerException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> selectOperationById(String processId) throws LogbookClientException, InvalidParseOperationException, AccessUnauthorizedException {
        return this.selectOperationById(processId, (JsonNode)new Select().getFinalSelect(), false, false);
    }

    @Override
    public RequestResponse<JsonNode> selectUnitLifeCycleById(String idUnit, JsonNode queryDsl) throws LogbookClientException, InvalidParseOperationException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"idUnit cannot be blank.", (String[])new String[]{idUnit});
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("/unitlifecycles/" + idUnit).withBody((Object)queryDsl, "QueryDsl cannot be empty or null.").withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (AccessInternalClientNotFoundException | AccessInternalClientServerException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> selectObjectGroupLifeCycleById(String idObject, JsonNode queryDsl) throws LogbookClientException, InvalidParseOperationException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block9: {
            ParametersChecker.checkParameter((String)"idObject cannot be blank.", (String[])new String[]{idObject});
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("/objectgrouplifecycles/" + idObject).withBody((Object)queryDsl, "QueryDsl cannot be empty or null.").withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (AccessInternalClientNotFoundException | AccessInternalClientServerException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> linkedCheckTraceability(JsonNode query) throws InvalidParseOperationException, LogbookClientException, AccessUnauthorizedException {
        RequestResponse requestResponse;
        block9: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(LOGBOOK_LINKED_CHECK).withJson().withBody((Object)query);
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (AccessInternalClientNotFoundException | AccessInternalClientServerException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new LogbookClientException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response downloadTraceabilityFile(String operationId) throws AccessInternalClientServerException, AccessInternalClientNotFoundException, InvalidParseOperationException, AccessUnauthorizedException {
        ParametersChecker.checkParameter((String)BLANK_TRACEABILITY_OPERATION_ID, (String[])new String[]{operationId});
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath("traceability/" + operationId + "/content").withOctetAccept());
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
        catch (BadRequestException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<JsonNode> exportDIP(JsonNode dslRequest) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath(DIPEXPORT).withBody((Object)dslRequest, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> exportByUsageFilter(ExportRequest exportRequest) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath(EXPORT_BY_USAGE_FILTER).withBody((Object)exportRequest, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response findExportByID(String id) throws AccessInternalClientServerException {
        ParametersChecker.checkParameter((String)BLANK_DSL, (String[])new String[]{id});
        try {
            return this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(DIPEXPORT + id + "/dip").withOctetAccept());
        }
        catch (VitamClientInternalException e) {
            throw new AccessInternalClientServerException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)e);
        }
    }

    @Override
    public Response findTransferSIPByID(String id) throws AccessInternalClientServerException {
        ParametersChecker.checkParameter((String)BLANK_DSL, (String[])new String[]{id});
        try {
            return this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(TRANSFER_EXPORT + id + "/sip").withOctetAccept());
        }
        catch (VitamClientInternalException e) {
            throw new AccessInternalClientServerException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)e);
        }
    }

    @Override
    public RequestResponse<JsonNode> reclassification(JsonNode reclassificationRequest) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/reclassification").withBody((Object)reclassificationRequest, "Missing reclassification request").withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> selectObjects(JsonNode selectQuery) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException {
        RequestResponse requestResponse;
        block10: {
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(OBJECTS).withBody((Object)selectQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (ForbiddenClientException e) {
                    throw new BadRequestException((Throwable)e);
                }
                catch (ExpectationFailedClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> selectUnitsWithInheritedRules(JsonNode selectQuery) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException {
        RequestResponse requestResponse;
        block10: {
            Response response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(UNITS_WITH_INHERITED_RULES).withBody((Object)selectQuery, BLANK_DSL).withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException e) {
                    throw new InvalidParseOperationException((Throwable)e);
                }
                catch (ForbiddenClientException e) {
                    throw new BadRequestException((Throwable)e);
                }
                catch (ExpectationFailedClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public Response downloadAccessLogFile(JsonNode params) throws AccessInternalClientServerException, AccessInternalClientNotFoundException, InvalidParseOperationException, AccessUnauthorizedException {
        Response response = null;
        boolean doNotCloseResponse = false;
        try {
            response = this.make(VitamRequestBuilder.get().withBefore(CHECK_REQUEST_ID).withPath(DataCategory.STORAGEACCESSLOG.getCollectionName()).withBody((Object)params, BLANK_DSL).withJsonOctet());
            this.check(response);
            doNotCloseResponse = true;
            Response response2 = response;
            return response2;
        }
        catch (BadRequestException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
        catch (ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
        finally {
            if (response != null && !doNotCloseResponse) {
                response.close();
            }
        }
    }

    @Override
    public RequestResponse<JsonNode> startEliminationAnalysis(EliminationRequestBody eliminationRequestBody) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/elimination/analysis").withBody((Object)eliminationRequestBody, "Missing elimination request").withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> startEliminationAction(EliminationRequestBody eliminationRequestBody) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/elimination/action").withBody((Object)eliminationRequestBody, "Missing elimination request").withJson());
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> startPreservation(PreservationRequest preservationRequest) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/preservation").withBody((Object)preservationRequest, "Missing request").withJson().withHeader("X-Access-Contract-Id", (Object)VitamThreadUtils.getVitamSession().getContractId());
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> deleteGotVersions(DeleteGotVersionsRequest deleteGotVersionsRequest) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/deleteGotVersions").withBody((Object)deleteGotVersionsRequest, "Missing request").withJson().withHeader("X-Access-Contract-Id", (Object)VitamThreadUtils.getVitamSession().getContractId());
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> startComputeInheritedRules(JsonNode dslQuery) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/units/computedInheritedRules").withBody((Object)dslQuery, "Missing request").withJson().withHeader("X-Access-Contract-Id", (Object)VitamThreadUtils.getVitamSession().getContractId());
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> deleteComputeInheritedRules(JsonNode dslQuery) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.delete().withBefore(CHECK_REQUEST_ID).withPath("/units/computedInheritedRules").withBody((Object)dslQuery, "Missing request").withJson().withHeader("X-Access-Contract-Id", (Object)VitamThreadUtils.getVitamSession().getContractId());
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    @Override
    public RequestResponse<JsonNode> startTransferReplyWorkflow(InputStream transferReply) throws AccessInternalClientServerException {
        RequestResponse requestResponse;
        block8: {
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transfers/reply").withBody((Object)transferReply, "Missing transfer reply").withJsonAccept().withXMLContentType().withBefore(CHECK_REQUEST_ID).withHeader("X-Access-Contract-Id", (Object)VitamThreadUtils.getVitamSession().getContractId());
            Response response = this.make(request);
            try {
                this.check(response);
                requestResponse = RequestResponse.parseFromResponse((Response)response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return requestResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RequestResponse<JsonNode> revertUnits(RevertUpdateOptions revertUpdateOptions) throws AccessInternalClientServerException, InvalidParseOperationException, AccessUnauthorizedException, NoWritingPermissionException {
        try {
            Response response = this.make(VitamRequestBuilder.post().withBefore(CHECK_REQUEST_ID).withPath("/revert/units").withBody((Object)revertUpdateOptions, BLANK_DSL).withJson());
            try {
                try {
                    this.check(response);
                }
                catch (BadRequestException e) {
                    VitamError vitamError = RequestResponse.parseVitamError((Response)response);
                    if (response == null) return vitamError;
                    response.close();
                    return vitamError;
                }
                RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response);
                return requestResponse;
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable;
                        throwable.addSuppressed(throwable2);
                    }
                }
            }
        }
        catch (AccessInternalClientNotFoundException | ExpectationFailedClientException | ForbiddenClientException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
    }

    @Override
    public Optional<AccessRequestReference> createObjectAccessRequest(String objectGroupId, String usage, int version) throws AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException {
        Optional<AccessRequestReference> optional;
        block8: {
            ParametersChecker.checkParameter((String)"object identifier should be filled", (String[])new String[]{objectGroupId});
            ParametersChecker.checkParameter((String)"Missing usage", (String[])new String[]{usage});
            VitamRequestBuilder request = VitamRequestBuilder.post().withPath(OBJECTS + URLEncoder.encode(objectGroupId, StandardCharsets.UTF_8) + "/accessRequest").withHeader("X-Qualifier", (Object)usage).withHeader("X-Version", (Object)version).withJson();
            Response response = this.make(request);
            try {
                this.check(response);
                RequestResponseOK requestResponse = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, AccessRequestReference.class);
                optional = Optional.ofNullable((AccessRequestReference)requestResponse.getFirstResult());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return optional;
    }

    @Override
    public List<StatusByAccessRequest> checkAccessRequestStatuses(List<AccessRequestReference> accessRequestReferences) throws AccessInternalClientServerException, AccessInternalClientIllegalOperationException {
        List list;
        block9: {
            ParametersChecker.checkParameter((String)"Required objectAccessRequests", (Object[])new Object[]{accessRequestReferences});
            VitamRequestBuilder request = VitamRequestBuilder.get().withPath("accessRequests/").withJson().withBody(accessRequestReferences);
            Response response = this.make(request);
            try {
                if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
                    throw new AccessInternalClientIllegalOperationException("Illegal Access Request operation on synchronous offer strategy");
                }
                this.check(response);
                RequestResponseOK requestResponse = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, StatusByAccessRequest.class);
                list = requestResponse.getResults();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
                    throw new AccessInternalClientServerException(e);
                }
            }
            response.close();
        }
        return list;
    }

    @Override
    public void removeAccessRequest(AccessRequestReference accessRequestReference) throws AccessInternalClientServerException, AccessInternalClientIllegalOperationException {
        ParametersChecker.checkParameter((String)"Access request required", (Object[])new Object[]{accessRequestReference});
        ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
        ParametersChecker.checkParameter((String)"Required storageStrategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("accessRequests/").withJson().withBody((Object)accessRequestReference);
        try (Response response = this.make(request);){
            if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode()) {
                throw new AccessInternalClientIllegalOperationException("Illegal Access Request operation on synchronous offer strategy");
            }
            this.check(response);
        }
        catch (AccessInternalClientNotFoundException | AccessUnauthorizedException | BadRequestException | ExpectationFailedClientException | ForbiddenClientException | NoWritingPermissionException | PreconditionFailedClientException | VitamClientInternalException e) {
            throw new AccessInternalClientServerException(e);
        }
    }

    private void check(Response response) throws AccessInternalClientServerException, AccessUnauthorizedException, AccessInternalClientNotFoundException, NoWritingPermissionException, BadRequestException, ForbiddenClientException, ExpectationFailedClientException, PreconditionFailedClientException {
        Response.Status status = response.getStatusInfo().toEnum();
        if (Response.Status.Family.SUCCESSFUL.equals((Object)status.getFamily())) {
            return;
        }
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                throw new AccessInternalClientServerException(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
            }
            case NOT_FOUND: {
                throw new AccessInternalClientNotFoundException(NOT_FOUND_EXCEPTION);
            }
            case UNAUTHORIZED: {
                throw new AccessUnauthorizedException(ACCESS_CONTRACT_EXCEPTION);
            }
            case BAD_REQUEST: {
                throw new BadRequestException(INVALID_PARSE_OPERATION);
            }
            case METHOD_NOT_ALLOWED: {
                throw new NoWritingPermissionException(NO_WRITING_PERMISSION);
            }
            case FORBIDDEN: {
                throw new ForbiddenClientException(FORBIDDEN_OPERATION);
            }
            case EXPECTATION_FAILED: {
                throw new ExpectationFailedClientException(REQUEST_PRECONDITION_FAILED);
            }
            case PRECONDITION_FAILED: {
                throw new PreconditionFailedClientException(Response.Status.PRECONDITION_FAILED.name());
            }
        }
        throw new AccessInternalClientServerException(status.toString());
    }
}

