/**
 * Copyright French Prime minister Office/SGMAP/DINSIC/Vitam Program (2019-2020)
 * and the signatories of the "VITAM - Accord du Contributeur" agreement.
 * <p>
 * contact@programmevitam.fr
 * <p>
 * This software is a computer program whose purpose is to implement
 * implement a digital archiving front-office system for the secure and
 * efficient high volumetry VITAM solution.
 * <p>
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 * <p>
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 * <p>
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 * <p>
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 */
package fr.gouv.vitamui.referential.common.dto.xml.archivalprofileunit;

import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileSedaVersion;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.List;

@XmlAccessorType(XmlAccessType.FIELD)
@Setter
@Getter
public class ArchivalProfileUnit implements Serializable {

    @XmlAttribute(name = "ID")
    private Integer id;

    @XmlAttribute(name = "Identifier")
    private String identifier;

    @XmlAttribute(name = "Name")
    private String name;

    @XmlAttribute(name = "Description")
    private String description;

    @XmlAttribute(name = "Version")
    private Integer version;

    @XmlElement(name = "Status")
    private ArchiveUnitProfileStatus status;

    @XmlElement(name = "SedaVersion")
    private ArchiveUnitProfileSedaVersion sedaVersion;

    @XmlElement(name = "Tenant")
    private Integer tenant;

    @XmlElement(name = "CreationDate")
    private String creationdate;

    @XmlElement(name = "LastUpdate")
    private String lastupdate;

    @XmlElement(name = "ActivationDate")
    private String activationdate;

    @XmlElement(name = "DeactivationDate")
    private String deactivationdate;

    @XmlElement(name = "ControlSchema")
    private String controlSchema;

    @XmlElement(name = "Fields")
    private List<String> fields;
}
