/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.server.config;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import javax.annotation.PostConstruct;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;

@Configuration
public class MongoDbConfig {
    @Autowired
    private MongoDatabaseFactory mongoDbFactory;

    @PostConstruct
    public void afterPropertiesSet() {
        this.setUpCertificateIndexOnData();
    }

    private void setUpCertificateIndexOnData() {
        MongoDatabase db = this.mongoDbFactory.getMongoDatabase();
        MongoCollection tenantsCollection = db.getCollection("certificates");
        Document doc = new Document();
        doc.append("data", (Object)"hashed");
        IndexOptions options = new IndexOptions();
        options.background(true);
        options.name("idx_certificate_data");
        tenantsCollection.createIndex((Bson)doc, options);
    }
}

