/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.client.UserRestClient;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class IamClientUserAuthenticationService
implements UserAuthenticationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamClientUserAuthenticationService.class);
    private final UserRestClient userRestClient;

    @Autowired
    public IamClientUserAuthenticationService(UserRestClient userRestClient) {
        this.userRestClient = userRestClient;
    }

    @Override
    public AuthUserDto getUserFromHttpContext(PreAuthenticatedAuthenticationToken token) {
        Integer tenantIdentifier;
        AuthUserDto userDto = this.getAuthenticatedUser(token);
        HttpContext httpContext = (HttpContext)token.getPrincipal();
        List userTenants = userDto.getProfileGroup().getProfiles().stream().filter(ProfileDto::isEnabled).map(ProfileDto::getTenantIdentifier).collect(Collectors.toList());
        if (!userTenants.contains(tenantIdentifier = httpContext.getTenantIdentifier())) {
            LOGGER.debug("Tenant id [{}] not in user tenants [{}]", (Object)tenantIdentifier, userTenants);
            throw new BadCredentialsException("This tenant: " + httpContext.getTenantIdentifier() + " is not allowed for this user: " + userDto.getId());
        }
        return userDto;
    }

    private AuthUserDto getAuthenticatedUser(PreAuthenticatedAuthenticationToken token) {
        String userToken = ((HttpContext)token.getPrincipal()).getUserToken();
        if (StringUtils.isBlank((String)userToken)) {
            throw new BadCredentialsException("User token is empty");
        }
        AuthUserDto userDto = this.userRestClient.getMe((HttpContext)token.getPrincipal());
        if (userDto == null) {
            throw new NotFoundException("User not found for token: " + userToken);
        }
        return userDto;
    }
}

