/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.provider;

import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.authentication.AuthenticationToken;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class InternalApiAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalApiAuthenticationProvider.class);
    private final UserAuthenticationService userAuthenticationService;

    public InternalApiAuthenticationProvider(UserAuthenticationService userAuthenticationService) {
        this.userAuthenticationService = userAuthenticationService;
    }

    public Authentication authenticate(Authentication authentication) {
        if (this.supports(authentication.getClass())) {
            PreAuthenticatedAuthenticationToken token = (PreAuthenticatedAuthenticationToken)authentication;
            HttpContext httpContext = (HttpContext)token.getPrincipal();
            LOGGER.debug("HttpContext: {}", (Object)httpContext);
            if (httpContext != null) {
                AuthUserDto userProfile = this.userAuthenticationService.getUserFromHttpContext(token);
                return new AuthenticationToken(userProfile, httpContext, null, Collections.singletonList("ROLE_INTERNAL"));
            }
        }
        throw new BadCredentialsException("Unable to authenticate REST call");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

