/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.provider;

import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.InvalidAuthenticationException;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.security.authentication.AuthenticationToken;
import fr.gouv.vitamui.iam.security.service.UserAuthenticationService;
import fr.gouv.vitamui.security.client.ContextRestClient;
import fr.gouv.vitamui.security.common.dto.ContextDto;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class ExternalApiAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalApiAuthenticationProvider.class);
    private final ContextRestClient contextRestClient;
    private final UserAuthenticationService userAuthenticationService;

    public ExternalApiAuthenticationProvider(ContextRestClient contextRestClient, UserAuthenticationService userAuthenticationService) {
        this.contextRestClient = contextRestClient;
        this.userAuthenticationService = userAuthenticationService;
    }

    public Authentication authenticate(Authentication authentication) {
        if (this.supports(authentication.getClass())) {
            PreAuthenticatedAuthenticationToken token = (PreAuthenticatedAuthenticationToken)authentication;
            HttpContext httpContext = (HttpContext)token.getPrincipal();
            X509Certificate certificate = (X509Certificate)token.getCredentials();
            LOGGER.debug("Principal: {}", (Object)httpContext);
            LOGGER.debug("Credential not null?: {}", (Object)(certificate != null ? 1 : 0));
            if (httpContext != null && certificate != null) {
                try {
                    ContextDto context = this.getContextFromHttpContext(httpContext, certificate);
                    AuthUserDto userDto = this.userAuthenticationService.getUserFromHttpContext(token);
                    Integer tenantIdentifier = httpContext.getTenantIdentifier();
                    List<String> intersectionRoles = this.getRoles(context, userDto, tenantIdentifier);
                    String applicationId = this.buildApplicationId(userDto, httpContext, context);
                    HttpContext newHttpContext = HttpContext.buildFromExternalHttpContext((HttpContext)httpContext, (String)applicationId);
                    return new AuthenticationToken(userDto, newHttpContext, certificate, intersectionRoles);
                }
                catch (InvalidAuthenticationException vitamuiException) {
                    throw new BadCredentialsException(vitamuiException.getMessage());
                }
            }
        }
        throw new BadCredentialsException("Unable to authenticate REST call");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }

    public String buildApplicationId(AuthUserDto user, HttpContext httpContext, ContextDto context) {
        return VitamUIUtils.generateApplicationId((String)httpContext.getApplicationId(), (String)context.getName(), (String)user.getIdentifier(), (String)user.getSuperUserIdentifier(), (String)user.getCustomerIdentifier(), (String)httpContext.getRequestId());
    }

    public ContextDto getContextFromHttpContext(HttpContext httpContext, X509Certificate certificate) {
        String certificateBase64;
        try {
            certificateBase64 = Base64.getEncoder().encodeToString(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new InvalidFormatException("Invalid certificate: " + e.getMessage());
        }
        try {
            ContextDto context = this.contextRestClient.findByCertificate(httpContext, certificateBase64);
            LOGGER.debug("authenticateInternal context={}", (Object)context);
            List contextTenants = context.getTenants();
            Integer tenantIdentifier = httpContext.getTenantIdentifier();
            if (!context.isFullAccess() && tenantIdentifier != null && !contextTenants.contains(tenantIdentifier)) {
                LOGGER.warn("[InvalidAuthenticationException] This tenant: {} is not allowed for the application context: {}. credential={}", new Object[]{tenantIdentifier, httpContext.getIdentity(), certificate});
                throw new BadCredentialsException("This tenant: " + tenantIdentifier + " is not allowed for the application context: " + httpContext.getIdentity());
            }
            return context;
        }
        catch (NotFoundException e) {
            LOGGER.error("Certificate not found [IssuerDN={}, certificateBase64={}, credential={}]", new Object[]{certificate.getIssuerDN(), certificateBase64, certificate});
            throw e;
        }
    }

    public List<String> getRoles(ContextDto context, AuthUserDto userProfile, int tenantIdentifier) {
        List contextRoles = context.extractRoleNames();
        LOGGER.debug("context roles: {}", (Object)contextRoles);
        List<String> userRoles = this.getUserRoles(userProfile, tenantIdentifier);
        return contextRoles.stream().filter(userRoles::contains).filter(role -> !"ROLE_INTERNAL".equals(role)).toList();
    }

    protected List<String> getUserRoles(AuthUserDto userProfile, int tenantIdentifier) {
        ArrayList<String> userRoles = new ArrayList<String>();
        userProfile.getProfileGroup().getProfiles().stream().filter(profile -> profile.getTenantIdentifier() == tenantIdentifier).filter(ProfileDto::isEnabled).forEach(profile -> {
            List<String> rolesNames = profile.getRoles().stream().map(role -> ApiUtils.ensureHasRolePrefix((String)role.getName())).toList();
            userRoles.addAll(rolesNames);
        });
        LOGGER.debug("user roles: {}", userRoles);
        return userRoles;
    }
}

