/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.config;

import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.iam.security.config.ApiAuthenticationEntryPoint;
import fr.gouv.vitamui.iam.security.filter.RequestHeadersAuthenticationFilter;
import fr.gouv.vitamui.iam.security.filter.TenantHeaderFilter;
import fr.gouv.vitamui.iam.security.filter.TokenExtractor;
import fr.gouv.vitamui.iam.security.filter.X509CertificateExtractor;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;

public abstract class ApiWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String GATEWAY_ENABLED = "gateway.enabled";
    private static final String CAS_TENANT_IDENTIFIER = "cas.tenant.identifier";
    private static final String CLIENT_CERTIFICATE_HEADER_NAME = "server.ssl.client-certificate-header-name";
    protected AuthenticationProvider apiAuthenticationProvider;
    protected RestExceptionHandler restExceptionHandler;
    protected SecurityService securityService;
    protected Environment env;
    private final boolean isGatewayEnabled;
    private final Integer casTenantIdentifier;

    public ApiWebSecurityConfig(AuthenticationProvider apiAuthenticationProvider, RestExceptionHandler restExceptionHandler, SecurityService securityService, Environment env) {
        this.apiAuthenticationProvider = apiAuthenticationProvider;
        this.restExceptionHandler = restExceptionHandler;
        this.securityService = securityService;
        this.env = env;
        this.isGatewayEnabled = (Boolean)env.getProperty(GATEWAY_ENABLED, Boolean.class, (Object)false);
        this.casTenantIdentifier = (Integer)env.getProperty(CAS_TENANT_IDENTIFIER, Integer.class, (Object)-1);
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider(this.apiAuthenticationProvider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.getAuthList())).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).cors().configurationSource(this::getCorsConfiguration).and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.getUnauthorizedHandler()).and()).csrf().disable()).addFilterAt((Filter)this.getRequestHeadersAuthenticationFilter(), BasicAuthenticationFilter.class).addFilterAt((Filter)this.getTenantHeaderFilter(), BasicAuthenticationFilter.class).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private CorsConfiguration getCorsConfiguration() {
        CorsConfiguration corsConfiguration = new CorsConfiguration().applyPermitDefaultValues();
        List<String> methodsAllowed = List.of(HttpMethod.GET.name(), HttpMethod.POST.name(), HttpMethod.HEAD.name(), HttpMethod.PATCH.name(), HttpMethod.PUT.name(), HttpMethod.DELETE.name());
        corsConfiguration.setAllowedMethods(methodsAllowed);
        return corsConfiguration;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(this.getAuthList());
    }

    protected String[] getAuthList() {
        return new String[]{"/error**", "/favicon.ico", "/actuator/**", "*/users/me", "/swagger-resources/**", "/swagger.json", "/**/swagger-resources/**", "/swagger-ui.html", "/v2/api-docs", "/webjars/**"};
    }

    @Bean
    protected ApiAuthenticationEntryPoint getUnauthorizedHandler() {
        return new ApiAuthenticationEntryPoint(this.restExceptionHandler);
    }

    protected AbstractPreAuthenticatedProcessingFilter getRequestHeadersAuthenticationFilter() throws Exception {
        return new RequestHeadersAuthenticationFilter(this.authenticationManager(), this.getX509CertificateExtractors(), this.getTokenExtractors());
    }

    protected TenantHeaderFilter getTenantHeaderFilter() {
        return new TenantHeaderFilter(this.securityService, this.casTenantIdentifier);
    }

    private List<X509CertificateExtractor> getX509CertificateExtractors() {
        ArrayList<X509CertificateExtractor> x509CertificateExtractors = new ArrayList<X509CertificateExtractor>();
        x509CertificateExtractors.add(X509CertificateExtractor.requestAttributeX509CertificateExtractor());
        if (this.isGatewayEnabled) {
            String certificateHeaderName = this.env.getProperty(CLIENT_CERTIFICATE_HEADER_NAME);
            x509CertificateExtractors.add(X509CertificateExtractor.requestHeaderX509CertificateExtractor(certificateHeaderName));
        }
        return x509CertificateExtractors;
    }

    private List<TokenExtractor> getTokenExtractors() {
        ArrayList<TokenExtractor> tokenExtractors = new ArrayList<TokenExtractor>();
        tokenExtractors.add(TokenExtractor.headerExtractor("X-User-Token"));
        if (this.isGatewayEnabled) {
            tokenExtractors.add(TokenExtractor.bearerExtractor());
        }
        return tokenExtractors;
    }

    private CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        return this.getCorsConfiguration();
    }

    @Generated
    public AuthenticationProvider getApiAuthenticationProvider() {
        return this.apiAuthenticationProvider;
    }

    @Generated
    public RestExceptionHandler getRestExceptionHandler() {
        return this.restExceptionHandler;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public Environment getEnv() {
        return this.env;
    }

    @Generated
    public boolean isGatewayEnabled() {
        return this.isGatewayEnabled;
    }

    @Generated
    public Integer getCasTenantIdentifier() {
        return this.casTenantIdentifier;
    }

    @Generated
    public void setApiAuthenticationProvider(AuthenticationProvider apiAuthenticationProvider) {
        this.apiAuthenticationProvider = apiAuthenticationProvider;
    }

    @Generated
    public void setRestExceptionHandler(RestExceptionHandler restExceptionHandler) {
        this.restExceptionHandler = restExceptionHandler;
    }

    @Generated
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Generated
    public void setEnv(Environment env) {
        this.env = env;
    }
}

