/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.authentication;

import fr.gouv.vitamui.commons.rest.client.HttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 7516300143014484275L;
    private final HttpContext credentials;
    private final X509Certificate certificate;
    private final AuthUserDto currentUser;

    public AuthenticationToken(AuthUserDto currentUser, HttpContext credentials, X509Certificate certificate, List<String> roles) {
        super(AuthenticationToken.buildAuthorities(roles));
        this.currentUser = currentUser;
        this.credentials = credentials;
        this.certificate = certificate;
        this.setAuthenticated(true);
    }

    private static List<GrantedAuthority> buildAuthorities(List<String> roles) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        roles.forEach(r -> authorities.add((GrantedAuthority)new SimpleGrantedAuthority(r)));
        return authorities;
    }

    public HttpContext getCredentials() {
        return this.credentials;
    }

    public AuthUserDto getPrincipal() {
        return this.currentUser;
    }

    public X509Certificate getDetails() {
        return this.certificate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityContext: ");
        sb.append("Principal: ").append(this.getPrincipal()).append("; ");
        sb.append("Credentials: [PROTECTED]; ");
        sb.append("Authenticated: ").append(this.isAuthenticated()).append("; ");
        if (!this.getAuthorities().isEmpty()) {
            sb.append("Granted Authorities: ");
            int i = 0;
            for (GrantedAuthority authority : this.getAuthorities()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(authority);
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

