/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.service;

import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.exception.UnexpectedDataException;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookEventDto;
import fr.gouv.vitamui.commons.vitam.xls.ExcelFileGeneratorUtils;
import fr.gouv.vitamui.iam.server.user.service.DateFormatService;
import fr.gouv.vitamui.iam.server.user.service.OperationParser;
import fr.gouv.vitamui.iam.server.user.service.TranslateService;
import java.io.IOException;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class UserExportService {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final List<String> SHEETS = List.of("Liste_utilisateurs", "Historique_modifications");
    private static final List<String> USER_LIST_COLUMNS_TITLES = List.of("Identifiant du user", "Nom", "Pr\u00e9nom", "Adresse e-mail", "Num\u00e9ro de mobile", "Num\u00e9ro de fixe", "Adresse ", "Code postal", "Ville", "Pays", "Code du centre", "Code du site", "Code interne", "Langue de l\u2019interface", "Niveau du groupe ", "Groupe de profils", "Type (nominatif ou g\u00e9n\u00e9rique)", "Compte subrogeable par le support (O/N)", "Validation en deux \u00e9tapes (O/N)", "Mise \u00e0 jour automatique SSO", "Date de derni\u00e8re connexion", "Compte (actif / inactif)");
    private static final List<String> USER_OPERATIONS_COLUMNS_TITLES = List.of("Identifiant du user", "Date d\u2019activit\u00e9", "Heure d\u2019activit\u00e9", "Activit\u00e9 r\u00e9alis\u00e9e par le user", "Activit\u00e9", "Ancienne valeur", "Nouvelle valeur");
    private static final List<EventType> EXT_VITAMUI_CREATE_EVENTS = List.of(EventType.EXT_VITAMUI_CREATE_USER, EventType.EXT_VITAMUI_CREATE_USER_INFO, EventType.EXT_VITAMUI_CREATE_OWNER);
    private final TranslateService translateService;
    private final DateFormatService dateFormatService;
    private final OperationParser operationParser;

    public void createXlsxFile(List<UserDto> data, List<LogbookEventDto> userOperations, Map<String, String> userInfoLangMap, Map<String, String> userGroupNameMap, OutputStream xlsOutputStream) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        SHEETS.forEach(arg_0 -> ((Workbook)workbook).createSheet(arg_0));
        Sheet userInformationSheet = workbook.getSheetAt(0);
        this.buildUserListSheet((Workbook)workbook, userInformationSheet, data, userInfoLangMap, userGroupNameMap);
        Sheet userOperationSheet = workbook.getSheetAt(1);
        this.buildUserOperationsSheet((Workbook)workbook, userOperationSheet, userOperations);
        workbook.write(xlsOutputStream);
        workbook.close();
    }

    private void buildUserOperationsSheet(Workbook workbook, Sheet sheet, List<LogbookEventDto> userOperations) {
        ExcelFileGeneratorUtils.addHeaderTitles((List)USER_OPERATIONS_COLUMNS_TITLES, (Sheet)sheet, (CellStyle)this.styleHeaderCells(workbook));
        this.insertUserOperationRows(sheet, userOperations);
        ExcelFileGeneratorUtils.resizeColumns((Sheet)sheet, (int)USER_OPERATIONS_COLUMNS_TITLES.size());
    }

    private void insertUserOperationRows(Sheet sheet, List<LogbookEventDto> userOperations) {
        int rowNum = 1;
        for (LogbookEventDto operation : userOperations) {
            Row row = sheet.createRow(rowNum++);
            this.insertUserOperationColumns(operation, row);
        }
    }

    private void insertUserOperationColumns(LogbookEventDto operation, Row row) {
        row.createCell(0).setCellValue(operation.getObId());
        String operationDateTime = operation.getEvDateTime();
        row.createCell(1).setCellValue(this.dateFormatService.formatDate(operationDateTime));
        row.createCell(2).setCellValue(this.dateFormatService.formatTime(operationDateTime));
        row.createCell(3).setCellValue(this.operationParser.parseUserId(operation.getEvIdAppSession()));
        row.createCell(4).setCellValue(this.translateService.translate(operation.getEvType()));
        row.createCell(5).setCellValue(this.parseOldValues(operation));
        row.createCell(6).setCellValue(this.parseNewValues(operation));
    }

    private String parseOldValues(LogbookEventDto operation) {
        if (this.isCreateEvent(operation.getEvType())) {
            return null;
        }
        String data = operation.getEvDetData();
        return this.operationParser.parseOldValues(data);
    }

    private String parseNewValues(LogbookEventDto operation) {
        if (this.isCreateEvent(operation.getEvType())) {
            return null;
        }
        String data = operation.getEvDetData();
        return this.operationParser.parseNewValues(data);
    }

    private boolean isCreateEvent(String event) {
        return EXT_VITAMUI_CREATE_EVENTS.stream().anyMatch(e -> event.equals(e.name()));
    }

    private void buildUserListSheet(Workbook workbook, Sheet sheet, List<UserDto> users, Map<String, String> userInfoLangMap, Map<String, String> userGroupNameMap) {
        ExcelFileGeneratorUtils.addHeaderTitles((List)USER_LIST_COLUMNS_TITLES, (Sheet)sheet, (CellStyle)this.styleHeaderCells(workbook));
        this.insertUserRows(sheet, users, userInfoLangMap, userGroupNameMap);
        ExcelFileGeneratorUtils.resizeColumns((Sheet)sheet, (int)USER_LIST_COLUMNS_TITLES.size());
    }

    protected void insertUserRows(Sheet sheet, List<UserDto> users, Map<String, String> userInfoLangMap, Map<String, String> userGroupNameMap) {
        if (CollectionUtils.isEmpty(users)) {
            throw new UnexpectedDataException("Users list data is empty");
        }
        int rowNum = 1;
        for (UserDto user : users) {
            Row row = sheet.createRow(rowNum++);
            String lastConnectionDate = user.getLastConnection() == null ? null : user.getLastConnection().format(DATE_FORMAT);
            String userLang = userInfoLangMap == null ? null : userInfoLangMap.get(user.getUserInfoId());
            String userGroupName = userGroupNameMap == null ? null : userGroupNameMap.get(user.getGroupId());
            String centerCodes = user.getCenterCodes() != null && !user.getCenterCodes().isEmpty() ? String.join((CharSequence)",", user.getCenterCodes()) : "";
            row.createCell(0).setCellValue(user.getIdentifier());
            row.createCell(1).setCellValue(user.getLastname());
            row.createCell(2).setCellValue(user.getFirstname());
            row.createCell(3).setCellValue(user.getEmail());
            row.createCell(4).setCellValue(user.getMobile());
            row.createCell(5).setCellValue(user.getPhone());
            row.createCell(6).setCellValue(user.getAddress().getStreet());
            row.createCell(7).setCellValue(user.getAddress().getZipCode());
            row.createCell(8).setCellValue(user.getAddress().getCity());
            row.createCell(9).setCellValue(user.getAddress().getCountry());
            row.createCell(10).setCellValue(centerCodes);
            row.createCell(11).setCellValue(user.getSiteCode());
            row.createCell(12).setCellValue(user.getInternalCode());
            row.createCell(13).setCellValue(this.translateService.translate(userLang));
            row.createCell(14).setCellValue(user.getLevel());
            row.createCell(15).setCellValue(userGroupName);
            row.createCell(16).setCellValue(this.translateService.translate(user.getType().name()));
            row.createCell(17).setCellValue(this.translateService.translate(user.isSubrogeable()));
            row.createCell(18).setCellValue(this.translateService.translate(user.isOtp()));
            row.createCell(19).setCellValue(this.translateService.translate(user.isAutoProvisioningEnabled()));
            row.createCell(20).setCellValue(lastConnectionDate);
            row.createCell(21).setCellValue(this.translateService.translate(user.getStatus().name()));
        }
    }

    protected CellStyle styleHeaderCells(Workbook workbook) {
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.BLACK.getIndex());
        CellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFont(headerFont);
        return headerCellStyle;
    }

    @Generated
    public UserExportService(TranslateService translateService, DateFormatService dateFormatService, OperationParser operationParser) {
        this.translateService = translateService;
        this.dateFormatService = dateFormatService;
        this.operationParser = operationParser;
    }
}

