/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.service;

import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.common.dto.ConnectionHistoryDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.user.converter.ConnectionHistoryConverter;
import fr.gouv.vitamui.iam.server.user.dao.ConnectionHistoryRepository;
import fr.gouv.vitamui.iam.server.user.domain.ConnectionHistory;
import fr.gouv.vitamui.iam.server.user.domain.User;
import fr.gouv.vitamui.iam.server.user.service.ConnectionHistoryExportService;
import fr.gouv.vitamui.iam.server.user.service.UserService;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConnectionHistoryService {
    private final ConnectionHistoryRepository connectionHistoryRepository;
    private final ConnectionHistoryConverter connectionHistoryConverter;
    private final ConnectionHistoryExportService connectionHistoryExportService;
    private final SecurityService securityService;
    private final UserService userService;

    @Autowired
    public ConnectionHistoryService(ConnectionHistoryRepository connectionHistoryRepository, ConnectionHistoryExportService exportService, SecurityService securityService, @Lazy UserService userService) {
        this.connectionHistoryRepository = connectionHistoryRepository;
        this.connectionHistoryConverter = new ConnectionHistoryConverter();
        this.connectionHistoryExportService = exportService;
        this.securityService = securityService;
        this.userService = userService;
    }

    public void saveUserConnection(ConnectionHistory connectionHistory) {
        this.connectionHistoryRepository.save((Object)connectionHistory);
    }

    public void deleteByUserId(String userId) {
        this.connectionHistoryRepository.deleteByUserId(userId);
    }

    public Resource exportConnectionHistory(Optional<String> optCriteria) {
        Map mapCriteria = optCriteria.map(criteria -> (Map)((Criterion)QueryDto.fromJson((String)criteria).getCriterionList().get(0)).getValue()).orElseGet(Collections::emptyMap);
        Date start = Optional.ofNullable(mapCriteria.getOrDefault("start", null)).map(Instant::parse).map(Date::from).orElse(null);
        Date end = Optional.ofNullable(mapCriteria.getOrDefault("end", null)).map(Instant::parse).map(Date::from).orElse(null);
        Assert.notNull((Object)start, (String)"The  start date must not be null");
        Assert.notNull((Object)end, (String)"The end date must not be null");
        AuthUserDto connectedUser = this.securityService.getUser();
        List userIdsFromCustomer = this.userService.findByCustomerId(connectedUser.getCustomerId()).stream().map(User::getIdentifier).collect(Collectors.toList());
        List connectionHistoryDto = this.findConnectionHistoryBetweenAndUserIds(start, end, userIdsFromCustomer);
        try {
            return this.connectionHistoryExportService.generateWorkbook(connectionHistoryDto);
        }
        catch (IOException e) {
            throw new InternalServerException("An error occurred while creating Users Connection History xls ", (Throwable)e);
        }
    }

    private List<ConnectionHistoryDto> findConnectionHistoryBetweenAndUserIds(Date start, Date end, List<String> userIds) {
        List listConnection = this.connectionHistoryRepository.findAllByConnectionDateTimeBetweenAndUserIdIn(start, end, userIds);
        return listConnection.stream().map(arg_0 -> ((ConnectionHistoryConverter)this.connectionHistoryConverter).convertEntityToDto(arg_0)).collect(Collectors.toList());
    }
}

