/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.service;

import fr.gouv.vitamui.commons.vitam.xls.ExcelFileGenerator;
import fr.gouv.vitamui.iam.common.dto.ConnectionHistoryDto;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ConnectionHistoryExportService
extends ExcelFileGenerator<ConnectionHistoryDto> {
    public static final List<String> CONNECTION_HISTORY_EXPORT_TITLE = List.of("ID de l\u2019utilisateur", "Date de connexion", "Heure de connexion");
    private List<ConnectionHistoryDto> data;

    public List<ConnectionHistoryDto> getData() {
        return this.data;
    }

    public List<String> getTitles() {
        return CONNECTION_HISTORY_EXPORT_TITLE;
    }

    public String getSheetName() {
        return "Donn\u00e9es";
    }

    public String getFileName(String identificationElement) {
        return String.format("reports-export-connection-%s.xlsx", DATE_TIME_FORMATTER_ISO_WITH_MS.format(Instant.now()));
    }

    protected void insertDataRows(Sheet sheet, List<ConnectionHistoryDto> data, Optional<CellStyle> dateStyle) {
        int rowIndex = 1;
        for (ConnectionHistoryDto element : data) {
            Row row = sheet.createRow(rowIndex);
            this.insertRow(row, element, dateStyle);
            ++rowIndex;
        }
    }

    public Resource generateWorkbook(List<ConnectionHistoryDto> data) throws IOException {
        this.data = data;
        byte[] output = this.createFile();
        return new ByteArrayResource(output);
    }

    public void insertRow(Row row, ConnectionHistoryDto data, Optional<CellStyle> dateStyle) {
        this.cellValueOf(row, 0, data.getUserId());
        if (data.getConnectionDateTime() == null) {
            return;
        }
        Instant instant = data.getConnectionDateTime().toInstant();
        LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        this.cellValueOf(row, 1, ldt.toLocalDate(), dateStyle);
        this.cellValueOf(row, 2, ldt.toLocalTime().toString());
    }
}

