/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.user.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.AddressDto;
import fr.gouv.vitamui.commons.api.domain.AlertAnalyticsDto;
import fr.gouv.vitamui.commons.api.domain.AnalyticsDto;
import fr.gouv.vitamui.commons.api.domain.ApplicationAnalyticsDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.server.common.converter.AddressConverter;
import fr.gouv.vitamui.iam.server.common.domain.Address;
import fr.gouv.vitamui.iam.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.server.user.domain.User;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class UserConverter
implements Converter<UserDto, User> {
    public static final String STATUS_KEY = "Statut";
    public static final String LASTNAME_KEY = "Nom";
    public static final String FIRSTNAME_KEY = "Pr\u00e9nom";
    public static final String EMAIL_KEY = "Email";
    public static final String LANGUAGE_KEY = "Langue";
    public static final String MOBILE_KEY = "Num\u00e9ro mobile";
    public static final String PHONE_KEY = "Num\u00e9ro fixe";
    public static final String LEVEL_KEY = "Niveau";
    public static final String TYPE_KEY = "Type";
    public static final String SUBROGEABLE_KEY = "Subrogeable";
    public static final String OTP_KEY = "OTP";
    public static final String GROUP_IDENTIFIER_KEY = "Groupe de profils";
    public static final String DISABLING_DATE = "Date de d\u00e9sactivation";
    public static final String REMOVING_DATE = "Date de suppression";
    public static final String INTERNAL_CODE_KEY = "Code interne";
    public static final String BLOCKED_DURATION = "Dur\u00e9e du blocage";
    public static final String SITE_CODE = "Code du site";
    public static final String AUTO_PROVISIONING_ENABLED_KEY = "Mise \u00e0 jour automatique";
    public static final String CENTER_CODES = "Code des centres";
    private final GroupRepository groupRepository;
    private final AddressConverter addressConverter;

    public UserConverter(GroupRepository groupRepository, AddressConverter addressConverter) {
        this.groupRepository = groupRepository;
        this.addressConverter = addressConverter;
    }

    public String convertToLogbook(UserDto user) {
        LinkedHashMap<String, String> userLogbookData = new LinkedHashMap<String, String>();
        userLogbookData.put(LASTNAME_KEY, "-");
        userLogbookData.put(FIRSTNAME_KEY, "-");
        userLogbookData.put(EMAIL_KEY, "-");
        userLogbookData.put(MOBILE_KEY, "-");
        userLogbookData.put(PHONE_KEY, "-");
        userLogbookData.put(TYPE_KEY, LogbookUtils.getValue((Object)user.getType().toString()));
        userLogbookData.put(STATUS_KEY, LogbookUtils.getValue((Object)user.getStatus().toString()));
        userLogbookData.put(SUBROGEABLE_KEY, LogbookUtils.getValue((Object)user.isSubrogeable()));
        userLogbookData.put(INTERNAL_CODE_KEY, LogbookUtils.getValue((Object)user.getInternalCode()));
        userLogbookData.put(AUTO_PROVISIONING_ENABLED_KEY, LogbookUtils.getValue((Object)user.isAutoProvisioningEnabled()));
        userLogbookData.put(OTP_KEY, LogbookUtils.getValue((Object)user.isOtp()));
        userLogbookData.put(DISABLING_DATE, LogbookUtils.getValue((Object)user.getDisablingDate()));
        userLogbookData.put(REMOVING_DATE, LogbookUtils.getValue((Object)user.getRemovingDate()));
        userLogbookData.put(SITE_CODE, LogbookUtils.getValue((Object)user.getSiteCode()));
        userLogbookData.put(CENTER_CODES, LogbookUtils.getValue((Object)user.getCenterCodes()));
        AddressDto address = new AddressDto("-", "-", "-", "-");
        this.addressConverter.addAddress(address, userLogbookData);
        Optional group = this.groupRepository.findById((Object)user.getGroupId());
        group.ifPresent(g -> userLogbookData.put(GROUP_IDENTIFIER_KEY, g.getIdentifier()));
        return ApiUtils.toJson(userLogbookData);
    }

    public User convertDtoToEntity(UserDto dto) {
        User user = new User();
        VitamUIUtils.copyProperties((Object)dto, (Object)user);
        user.setLastname(StringUtils.upperCase((String)dto.getLastname()));
        user.setFirstname(StringUtils.capitalize((String)dto.getFirstname()));
        if (dto.getAddress() != null) {
            user.setAddress((Address)VitamUIUtils.copyProperties((Object)dto.getAddress(), (Object)new Address()));
        }
        return user;
    }

    public UserDto convertEntityToDto(User user) {
        if (user == null) {
            return null;
        }
        UserDto userDto = new UserDto();
        AnalyticsDto analyticsDto = new AnalyticsDto();
        VitamUIUtils.copyProperties((Object)user, (Object)userDto);
        if (user.getAddress() != null) {
            userDto.setAddress((AddressDto)VitamUIUtils.copyProperties((Object)user.getAddress(), (Object)new AddressDto()));
        }
        if (user.getAnalytics() != null) {
            ArrayList applicationAnalyticsDtoList = new ArrayList();
            user.getAnalytics().getApplications().forEach(application -> {
                ApplicationAnalyticsDto applicationAnalyticsDto = new ApplicationAnalyticsDto();
                applicationAnalyticsDto.setApplicationId(application.getApplicationId());
                applicationAnalyticsDto.setLastAccess(application.getLastAccess());
                applicationAnalyticsDto.setAccessCounter(application.getAccessCounter());
                applicationAnalyticsDtoList.add(applicationAnalyticsDto);
            });
            ArrayList alertAnalyticsDtoDtoList = new ArrayList();
            user.getAnalytics().getAlerts().forEach(alert -> {
                AlertAnalyticsDto alertAnalyticsDto = new AlertAnalyticsDto();
                BeanUtils.copyProperties((Object)alert, (Object)alertAnalyticsDto);
                alertAnalyticsDtoDtoList.add(alertAnalyticsDto);
            });
            analyticsDto.setApplications(applicationAnalyticsDtoList);
            analyticsDto.setAlerts(alertAnalyticsDtoDtoList);
            analyticsDto.setLastTenantIdentifier(user.getAnalytics().getLastTenantIdentifier());
            userDto.setAnalytics(analyticsDto);
        }
        return userDto;
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public AddressConverter getAddressConverter() {
        return this.addressConverter;
    }
}

