/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.server.tenant.service.TenantService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/tenants"})
@Api(tags={"tenants"}, value="Tenants Management")
public class TenantController
implements CrudController<TenantDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantController.class);
    private final TenantService tenantService;

    @Autowired
    public TenantController(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    @Secured(value={"ROLE_GET_ALL_TENANTS"})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.tenantService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_TENANTS", "ROLE_GET_ALL_TENANTS"})
    public TenantDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {}", (Object)id);
        return (TenantDto)this.tenantService.getOne(id);
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_TENANTS"})
    public TenantDto create(@Valid @RequestBody TenantDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.tenantService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_TENANTS"})
    public TenantDto update(@PathVariable(value="id") String id, @Valid @RequestBody TenantDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return (TenantDto)this.tenantService.update((IdDto)dto);
    }

    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_UPDATE_TENANTS"})
    public TenantDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch tenant {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch tenant : the DTO id must match the path id");
        return this.tenantService.patch(partialDto);
    }

    @Secured(value={"ROLE_GET_TENANTS"})
    @GetMapping
    public Collection<TenantDto> getAll(@RequestParam Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all criteria={}", criteria);
        return this.tenantService.getAll(criteria);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for tenant with id :{}", (Object)id);
        return this.tenantService.findHistoryById(id);
    }

    @GetMapping(value={"/available"})
    @Secured(value={"ROLE_GET_TENANTS", "ROLE_GET_ALL_TENANTS"})
    public List<Integer> getAvailableTenants() {
        LOGGER.debug("Retrieve Vitam available tenants  ");
        return this.tenantService.getAvailableTenantsIds();
    }

    @Generated
    public TenantService getTenantService() {
        return this.tenantService;
    }
}

