/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.profile.service.ProfileService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/profiles"})
@Api(tags={"profiles"}, value="Profiles Management", description="Profiles Management")
public class ProfileController
implements CrudController<ProfileDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileController.class);
    protected static final String CUSTOMER_ID_KEY = "customerId";
    protected static final String TENANT_IDENTIFIER_KEY = "tenantIdentifier";
    protected static final String LEVEL_KEY = "level";
    private final ProfileService profileService;
    private final SecurityService securityService;

    @Autowired
    public ProfileController(ProfileService profileService, SecurityService securityService) {
        this.profileService = profileService;
        this.securityService = securityService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_PROFILES"})
    public Collection<ProfileDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get all with criteria={}, embedded={}", criteria, embedded);
        return this.profileService.getAll(criteria, embedded);
    }

    @Secured(value={"ROLE_GET_PROFILES"})
    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria((Object)criteria);
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.profileService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_PROFILES"})
    public ProfileDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get {}, embedded={}", (Object)id, embedded);
        return (ProfileDto)this.profileService.getOne(id, Optional.empty(), embedded);
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_PROFILES"})
    public ProfileDto create(@Valid @RequestBody ProfileDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        this.profileService.checkCustomerId(dto.getCustomerId(), "Unable to create profile " + dto.getName());
        this.profileService.checkTenantIdentifier(dto.getTenantIdentifier(), "Unable to create profile");
        return this.profileService.create(dto);
    }

    public ProfileDto update(@PathVariable(value="id") String id, @Valid @RequestBody ProfileDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @Secured(value={"ROLE_GET_PROFILES"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(size), String.valueOf(page)});
        SanityChecker.sanitizeCriteria(criteria);
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, direction={}, embedded = {}", new Object[]{page, size, criteria, orderBy, direction, embedded});
        return this.profileService.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_PROFILES"})
    public ProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        String customerId = CastUtils.toString((Object)partialDto.get(CUSTOMER_ID_KEY));
        Integer tenantIdentifier = CastUtils.toInteger((Object)partialDto.get(TENANT_IDENTIFIER_KEY));
        String level = CastUtils.toString((Object)partialDto.get(LEVEL_KEY));
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            this.profileService.checkCustomerId(customerId, "Unable to patch profile");
        }
        if (tenantIdentifier != null) {
            this.profileService.checkTenantIdentifier(tenantIdentifier, "Unable to patch profile");
        }
        if (StringUtils.isNotEmpty((CharSequence)level)) {
            this.profileService.checkLevel(level, "Unable to patch profile");
        }
        partialDto.put(CUSTOMER_ID_KEY, this.securityService.getCustomerId());
        partialDto.put(TENANT_IDENTIFIER_KEY, this.securityService.getTenantIdentifier());
        return this.profileService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for profile with id :{}", (Object)id);
        return this.profileService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    @Secured(value={"ROLE_GET_PROFILES"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.profileService.getLevels(criteria);
    }

    @Generated
    public ProfileService getProfileService() {
        return this.profileService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

