/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookLifeCycleResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.tenant.service.TenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"logbooks"})
@RequestMapping(value={"/v1"})
@RestController
@ResponseBody
public class LogbookController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogbookController.class);
    protected final SecurityService securityService;
    private final LogbookService logbookService;
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private static final String DOWNLOAD_TYPE_DIP = "dip";
    private static final String DOWNLOAD_TYPE_TRANSFER_SIP = "transfersip";
    private static final String DOWNLOAD_TYPE_BATCH_REPORT = "batchreport";
    private static final String DOWNLOAD_TYPE_OBJECT = "object";
    private final TenantService tenantService;

    @Autowired
    public LogbookController(LogbookService logbookService, SecurityService securityService, TenantService tenantService) {
        this.logbookService = logbookService;
        this.securityService = securityService;
        this.tenantService = tenantService;
    }

    @ApiOperation(value="Get log book operation by json select")
    @Secured(value={"ROLE_LOGBOOKS"})
    @PostMapping(value={"/logbooks/operations"})
    public LogbookOperationsCommonResponseDto findOperations(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestBody JsonNode select, @RequestParam(required=false) Integer vitamTenantIdentifier) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        VitamContext vitamContext;
        SanityChecker.sanitizeJson((JsonNode)select);
        SanityChecker.sanitizeCriteria((Object)select);
        if (Objects.nonNull(vitamTenantIdentifier)) {
            TenantDto requestedTenant = this.tenantService.findByIdentifier(vitamTenantIdentifier);
            if (Objects.isNull(requestedTenant)) {
                throw new BadRequestException(String.format("Tenant not found with identifier : '%d'", vitamTenantIdentifier));
            }
            vitamContext = this.securityService.buildVitamContext(vitamTenantIdentifier);
        } else {
            vitamContext = this.securityService.buildVitamContext(tenantId);
        }
        return (LogbookOperationsCommonResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.selectOperations(select, vitamContext).toJsonNode(), LogbookOperationsCommonResponseDto.class);
    }

    @ApiOperation(value="Get operation by id")
    @GetMapping(value={"/logbooks/operations/{id}"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public LogbookOperationsCommonResponseDto findOperationByUnitId(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Get log book operation by id : {} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        return (LogbookOperationsCommonResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.selectOperationbyId(id, vitamContext).toJsonNode(), LogbookOperationsCommonResponseDto.class);
    }

    @ApiOperation(value="Get unit lifecycle by id")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/unitlifecycles/{id}"})
    public LogbookLifeCycleResponseDto findUnitLifeCyclesByUnitId(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Get unit lifecycle by id : {} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        return (LogbookLifeCycleResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.findUnitLifeCyclesByUnitId(id, vitamContext).toJsonNode(), LogbookLifeCycleResponseDto.class);
    }

    @ApiOperation(value="Get object lifecycle by id")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/objectslifecycles/{id}"})
    public LogbookLifeCycleResponseDto findObjectGroupLifeCyclesByUnitId(@RequestHeader(required=true, value="X-Tenant-Id") Integer tenantId, @RequestHeader(required=true, value="X-Access-Contract-Id") String accessContractId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Get object lifecycle by id : {} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        return (LogbookLifeCycleResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.findObjectGroupLifeCyclesByUnitId(id, vitamContext).toJsonNode(), LogbookLifeCycleResponseDto.class);
    }

    @ApiOperation(value="Download the manifest for a given operation")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/operations/{id}/download/manifest"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadManifest(@RequestHeader(value="X-Tenant-Id") Integer tenantIdentifier, @PathVariable String id, HttpServletResponse response) throws IOException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the manifest for the following Vitam operation : {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantIdentifier);
        try (Response vitamResponse = this.logbookService.downloadManifest(id, vitamContext);){
            VitamRestUtils.writeFileResponse((Response)vitamResponse, (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="Download the ATR for a given operation")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/operations/{id}/download/atr"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadAtr(@RequestHeader(value="X-Tenant-Id") Integer tenantIdentifier, @PathVariable String id, HttpServletResponse response) throws IOException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the ATR file for the following Vitam operation : {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantIdentifier);
        try (Response vitamResponse = this.logbookService.downloadAtr(id, vitamContext);){
            VitamRestUtils.writeFileResponse((Response)vitamResponse, (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="Download the report file for a given operation")
    @GetMapping(value={"/logbooks/operations/{id}/download/{downloadType}"}, produces={"application/octet-stream"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadReport(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId, @PathVariable String id, @PathVariable String downloadType, HttpServletResponse response) throws VitamClientException, IOException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, downloadType, accessContractId});
        LOGGER.debug("Download the report file for the Vitam operation : {} with download type : {}", (Object)id, (Object)downloadType);
        LOGGER.debug("Access Contract {} ", (Object)accessContractId);
        ParameterChecker.checkParameter((String)"The identifier, the accessContract, and Id are mandatory parameters: ", (String[])new String[]{id, accessContractId});
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        try (Response vitamResponse = this.logbookService.downloadReport(id, downloadType, vitamContext);){
            String fileName = LogbookController.getDownloadReportFileName((String)id, (String)downloadType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            VitamRestUtils.writeFileResponse((Response)vitamResponse, (HttpServletResponse)response);
        }
    }

    private static String getDownloadReportFileName(String id, String downloadType) {
        Object fileName = id;
        switch (downloadType) {
            case "object": {
                fileName = (String)fileName + ".xml";
                break;
            }
            case "batchreport": {
                fileName = (String)fileName + ".jsonl";
                break;
            }
            case "dip": 
            case "transfersip": {
                fileName = (String)fileName + ".zip";
                break;
            }
            default: {
                fileName = (String)fileName + ".json";
            }
        }
        return fileName;
    }
}

