/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.common.ProviderEmbeddedOptions;
import fr.gouv.vitamui.iam.common.utils.IamUtils;
import fr.gouv.vitamui.iam.server.domain.dto.ProviderPatchType;
import fr.gouv.vitamui.iam.server.idp.service.IdentityProviderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/iam/v1/providers"})
@Api(tags={"identityproviders"}, value="Identity Providers Management")
public class IdentityProviderController
implements CrudController<IdentityProviderDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityProviderController.class);
    @Autowired
    private IdentityProviderService identityProviderService;

    public IdentityProviderController(IdentityProviderService identityProviderService) {
        this.identityProviderService = identityProviderService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_PROVIDERS"})
    public List<IdentityProviderDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(ProviderEmbeddedOptions.class, embedded);
        LOGGER.debug("Get all criteria={}, embedded={}", criteria, embedded);
        return this.identityProviderService.getAll(criteria, embedded);
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_PROVIDERS"})
    public IdentityProviderDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(ProviderEmbeddedOptions.class, embedded);
        LOGGER.debug("Get {} criteria={} embedded={}", new Object[]{id, criteria, embedded});
        return (IdentityProviderDto)this.identityProviderService.getOne(id, criteria, embedded);
    }

    @GetMapping(value={"/{id}/idpMetadata"})
    @Secured(value={"ROLE_GET_PROVIDERS"})
    public ResponseEntity<Resource> getIdpMetadataProviderByProviderId(@PathVariable(value="id") String id) throws PreconditionFailedException, IOException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        Resource resource = this.identityProviderService.getMetadataProviderByProviderId(id, ProviderEmbeddedOptions.IDPMETADATA, IamUtils.buildOptionalEmbedded((Enum[])new Enum[]{ProviderEmbeddedOptions.IDPMETADATA}));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=idpmetadata.xml");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    @GetMapping(value={"/{id}/spMetadata"})
    @Secured(value={"ROLE_GET_PROVIDERS"})
    public ResponseEntity<Resource> getSpMetadataProviderByProviderId(@PathVariable(value="id") String id) throws PreconditionFailedException, IOException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        Resource resource = this.identityProviderService.getMetadataProviderByProviderId(id, ProviderEmbeddedOptions.SPMETADATA, IamUtils.buildOptionalEmbedded((Enum[])new Enum[]{ProviderEmbeddedOptions.SPMETADATA}));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=spmetadata.xml");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(String criteria) {
        throw new UnsupportedOperationException("checkExist not implemented");
    }

    @PostMapping
    @ApiIgnore
    @ApiOperation(value="Create entity request to upload the file", produces="application/json", consumes="multipart/form-data")
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"ROLE_CREATE_PROVIDERS"})
    public IdentityProviderDto create(@RequestPart String provider, @RequestPart(value="keystore", required=false) MultipartFile keystore, @RequestPart(value="idpMetadata", required=false) MultipartFile idpMetadata) throws Exception {
        LOGGER.debug("Create provider: {}", (Object)provider);
        if (Objects.nonNull(keystore) && Objects.nonNull(idpMetadata)) {
            SanityChecker.isValidFileName((String)keystore.getOriginalFilename());
            SanityChecker.isValidFileName((String)idpMetadata.getOriginalFilename());
        }
        IdentityProviderDto dto = this.identityProviderService.mapToIdentityProviderDto(keystore, idpMetadata, provider);
        return this.identityProviderService.create(dto);
    }

    public IdentityProviderDto create(@Valid @RequestBody IdentityProviderDto dto) {
        throw new UnsupportedOperationException("checkExist not implemented");
    }

    public IdentityProviderDto update(@PathVariable(value="id") String id, @Valid @RequestBody IdentityProviderDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @ApiOperation(value="Update partially provider")
    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_PROVIDERS"})
    public IdentityProviderDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.identityProviderService.patch(partialDto);
    }

    @PatchMapping(value={"/{id}/keystore"})
    @ApiOperation(value="Update keystore provider")
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_UPDATE_PROVIDERS"})
    @ApiIgnore
    public IdentityProviderDto patchProviderKeystore(@RequestPart(value="keystore") MultipartFile keystore, @RequestPart(value="provider") String provider, @PathVariable String id) throws IOException {
        ParameterChecker.checkParameter((String)"Parameters are mandatory : ", (Object[])new Object[]{keystore, provider, id});
        SanityChecker.isValidFileName((String)keystore.getOriginalFilename());
        LOGGER.debug("Update keystore provider id={} with partialDto={}", (Object)id, (Object)provider);
        return this.identityProviderService.patch((Map)VitamUIUtils.convertObjectFromJson((String)provider, Map.class), keystore, null, id, ProviderPatchType.KEYSTORE);
    }

    @PatchMapping(value={"/{id}/idpMetadata"})
    @ApiOperation(value="Update idpMetadata provider")
    @ResponseStatus(value=HttpStatus.OK)
    @Secured(value={"ROLE_UPDATE_PROVIDERS"})
    @ApiIgnore
    public IdentityProviderDto patchProviderIdpMetadata(@RequestPart(value="idpMetadata") MultipartFile idpMetadata, @RequestPart(value="provider") String provider, @PathVariable String id) throws IOException {
        ParameterChecker.checkParameter((String)"Parameters are mandatory : ", (Object[])new Object[]{provider, idpMetadata, id});
        SanityChecker.isValidFileName((String)idpMetadata.getOriginalFilename());
        LOGGER.debug("Update idpMetadata provider id={} with partialDto", (Object)id, (Object)provider);
        return this.identityProviderService.patch((Map)VitamUIUtils.convertObjectFromJson((String)provider, Map.class), null, idpMetadata, id, ProviderPatchType.IDPMETADATA);
    }

    @Generated
    public IdentityProviderService getIdentityProviderService() {
        return this.identityProviderService;
    }

    @Generated
    public void setIdentityProviderService(IdentityProviderService identityProviderService) {
        this.identityProviderService = identityProviderService;
    }
}

