/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.iam.server.externalParameters.service.ExternalParametersService;
import io.swagger.annotations.Api;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/externalparameters"})
@Api(tags={"externalParameters"}, value="External Parameters Management")
public class ExternalParametersController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalParametersController.class);
    private ExternalParametersService externalParametersService;

    @Autowired
    public ExternalParametersController(ExternalParametersService externalParametersService) {
        this.externalParametersService = externalParametersService;
    }

    @GetMapping(value={"/me"})
    @Secured(value={"ROLE_GET_EXTERNAL_PARAMS", "ROLE_INTERNAL"})
    public Map<String, String> getMyExternalParameters() {
        LOGGER.debug("GetMyExternalParameters");
        ExternalParametersDto userParameters = this.externalParametersService.getMyExternalParameters();
        if (userParameters != null && userParameters.getParameters() != null) {
            return userParameters.getParameters().stream().collect(Collectors.toMap(ParameterDto::getKey, ParameterDto::getValue));
        }
        return Collections.emptyMap();
    }

    @Generated
    public ExternalParametersService getExternalParametersService() {
        return this.externalParametersService;
    }

    @Generated
    public void setExternalParametersService(ExternalParametersService externalParametersService) {
        this.externalParametersService = externalParametersService;
    }
}

