/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsCommonResponseDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.server.externalparamprofile.service.ExternalParamProfileService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/externalparamprofile"})
@Api(tags={"externalparamprofile"}, value="Access Contract External Parameters Profile")
public class ExternalParamProfileController
implements CrudController<ExternalParamProfileDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalParamProfileController.class);
    private final ExternalParamProfileService externalParamProfileService;

    @Autowired
    public ExternalParamProfileController(ExternalParamProfileService externalParamProfileService) {
        this.externalParamProfileService = externalParamProfileService;
    }

    @Secured(value={"ROLE_SEARCH_EXTERNAL_PARAM_PROFILE"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ExternalParamProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        direction.ifPresent(SanityChecker::sanitizeCriteria);
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}, embedded = {}", new Object[]{page, size, criteria, orderBy, direction, embedded});
        return this.externalParamProfileService.getAllPaginated(page, size, (String)criteria.orElse(null), (String)orderBy.orElse(null), (DirectionDto)direction.orElse(null));
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    @Secured(value={"ROLE_CREATE_EXTERNAL_PARAM_PROFILE"})
    public ResponseEntity<Void> checkExist(String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.externalParamProfileService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create external parameter profile")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto create(@RequestBody ExternalParamProfileDto entityDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)entityDto);
        LOGGER.debug("create class={}", (Object)entityDto.getClass().getName());
        return this.externalParamProfileService.create(entityDto);
    }

    @ApiOperation(value="Update external parameter profile")
    @PutMapping(value={"/{id}"})
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto update(String id, ExternalParamProfileDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_SEARCH_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto getOne(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get One with id : {}", (Object)id);
        return this.externalParamProfileService.getOne(id);
    }

    @ApiOperation(value="get history by external parameter profile profile's id")
    @GetMapping(value={"/{id}/history"})
    @Secured(value={"ROLE_SEARCH_EXTERNAL_PARAM_PROFILE"})
    public LogbookOperationsCommonResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for external parameter profile with id :{}", (Object)id);
        return this.externalParamProfileService.findHistoryById(id);
    }

    @PatchMapping(value={"/me"})
    @Secured(value={"ROLE_EDIT_EXTERNAL_PARAM_PROFILE"})
    public ExternalParamProfileDto patchMe(@RequestBody Map<String, Object> partialDto) throws PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        return this.externalParamProfileService.patch(partialDto);
    }
}

