/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.rest;

import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.server.application.service.ApplicationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/applications"})
@Api(tags={"applications"}, value="Applications Management", description="Applications Management")
public class ApplicationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationController.class);
    private final ApplicationService applicationService;

    @Autowired
    public ApplicationController(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @GetMapping
    public List<ApplicationDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get all with criteria={}, embedded={}", criteria, embedded);
        return this.applicationService.getAll(criteria, embedded);
    }

    @GetMapping(value={"/filtered"})
    @ApiOperation(value="Return config about applications and categories")
    public Map<String, Object> getApplicationsFromUi(@RequestParam(defaultValue="true") boolean filterApp) {
        LOGGER.debug("getApplications");
        return this.applicationService.getApplications(filterApp);
    }

    @GetMapping(path={"/{identifier:.+}/externalid"})
    @ApiOperation(value="Check if an application can have an external identifier")
    public boolean isApplicationExternalIdentifierEnabled(@PathVariable(value="identifier") String identifier) {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("isApplicationExternalIdentifierEnabled");
        return this.applicationService.isApplicationExternalIdentifierEnabled(identifier);
    }

    @PutMapping(value={"/{id}"})
    public ApplicationDto update(@PathVariable(value="id") String id, @Valid @RequestBody ApplicationDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @PatchMapping(value={"/{id}"})
    public ApplicationDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        throw new UnsupportedOperationException("patch not implemented");
    }

    @Generated
    public ApplicationService getApplicationService() {
        return this.applicationService;
    }
}

