/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.provisioning.service;

import fr.gouv.vitamui.commons.api.domain.AddressDto;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.rest.client.BaseWebClientFactory;
import fr.gouv.vitamui.iam.common.dto.ProvidedUserDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.provisioning.client.ProvisioningWebClient;
import fr.gouv.vitamui.iam.server.provisioning.config.IdPProvisioningClientConfiguration;
import fr.gouv.vitamui.iam.server.provisioning.config.ProvisioningClientConfiguration;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class ProvisioningService {
    private final WebClient.Builder webClientBuilder;
    private final ProvisioningClientConfiguration provisioningClientConfiguration;
    private final SecurityService securityService;
    @Value(value="${address.max-street-length}")
    @NotNull
    private int maxStreetLength;

    public ProvisioningService(WebClient.Builder webClientBuilder, ProvisioningClientConfiguration provisioningClientConfiguration, SecurityService securityService) {
        this.webClientBuilder = webClientBuilder;
        this.provisioningClientConfiguration = provisioningClientConfiguration;
        this.securityService = securityService;
    }

    public ProvidedUserDto getUserInformation(String idp, String email, String loginCustomerId, String groupId, String unit, String userIdentifier) {
        IdPProvisioningClientConfiguration idpProvisioningClient = this.getProvisioningClientConfiguration(idp);
        try (ProvisioningWebClient webClient = this.buildWebClient(idpProvisioningClient);){
            ProvidedUserDto providedUser = webClient.getProvidedUser(this.securityService.getHttpContext(), email, loginCustomerId, groupId, unit, userIdentifier);
            if (Objects.isNull(providedUser)) {
                throw new NotFoundException(String.format("No user returned by provisioning with email %s, technicalUserId %s, idp %s", email, userIdentifier, idp));
            }
            AddressDto address = providedUser.getAddress();
            if (address != null) {
                String shortStreetAddress = StringUtils.substring((String)address.getStreet(), (int)0, (int)this.maxStreetLength);
                address.setStreet(shortStreetAddress);
                providedUser.setAddress(address);
            }
            ProvidedUserDto providedUserDto = providedUser;
            return providedUserDto;
        }
    }

    protected IdPProvisioningClientConfiguration getProvisioningClientConfiguration(String idp) {
        return this.provisioningClientConfiguration.getIdentityProviders().stream().filter(provisioningClient -> provisioningClient.getIdpIdentifier().equalsIgnoreCase(idp)).findFirst().orElseThrow(() -> new NotFoundException(String.format("Provisioning client configuration not found for IdP : %S", idp)));
    }

    protected ProvisioningWebClient buildWebClient(IdPProvisioningClientConfiguration idpProvisioningClient) {
        BaseWebClientFactory clientFactory = new BaseWebClientFactory(idpProvisioningClient.getClient(), null, this.webClientBuilder, idpProvisioningClient.getUri());
        return new ProvisioningWebClient(clientFactory.getWebClient(), idpProvisioningClient.getUri());
    }
}

