/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.profile.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.server.profile.domain.Profile;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProfileConverter
implements Converter<ProfileDto, Profile> {
    public static final String APPLICATION_NAME_KEY = "Application";
    public static final String ENABLED_KEY = "Activ\u00e9";
    public static final String TENANT_IDENTIFIER_KEY = "Identifiant du tenant";
    public static final String NAME_KEY = "Nom";
    public static final String LEVEL_KEY = "Niveau";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String ROLES_KEY = "Liste des r\u00f4les";
    public static final String EXTERNAL_PARAM_IDENTIFIER = "Identifiant des droits du profil";

    public String convertToLogbook(ProfileDto source) {
        LinkedHashMap<String, String> profileLogbookData = new LinkedHashMap<String, String>();
        profileLogbookData.put(APPLICATION_NAME_KEY, LogbookUtils.getValue((Object)source.getApplicationName()));
        profileLogbookData.put(NAME_KEY, LogbookUtils.getValue((Object)source.getName()));
        profileLogbookData.put(DESCRIPTION_KEY, LogbookUtils.getValue((Object)source.getDescription()));
        profileLogbookData.put(LEVEL_KEY, LogbookUtils.getValue((Object)source.getLevel()));
        profileLogbookData.put(ENABLED_KEY, LogbookUtils.getValue((Object)source.isEnabled()));
        profileLogbookData.put(ROLES_KEY, this.convertRoleToLogbook((Collection)source.getRoles()));
        if (StringUtils.isNotBlank((CharSequence)source.getExternalParamIdentifier())) {
            profileLogbookData.put(EXTERNAL_PARAM_IDENTIFIER, source.getExternalParamIdentifier());
        }
        return ApiUtils.toJson(profileLogbookData);
    }

    public Profile convertDtoToEntity(ProfileDto dto) {
        return (Profile)VitamUIUtils.copyProperties((Object)dto, (Object)new Profile());
    }

    public ProfileDto convertEntityToDto(Profile profile) {
        return (ProfileDto)VitamUIUtils.copyProperties((Object)profile, (Object)new ProfileDto());
    }

    public String convertRoleToLogbook(Collection<Role> roles) {
        List rolesName = roles.stream().map(r -> r.getName()).collect(Collectors.toList());
        rolesName.sort(Comparator.naturalOrder());
        return rolesName.toString();
    }
}

