/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.owner.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.AddressDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.server.common.converter.AddressConverter;
import fr.gouv.vitamui.iam.server.owner.domain.Owner;
import java.util.LinkedHashMap;

public class OwnerConverter
implements Converter<OwnerDto, Owner> {
    public static final String CODE_KEY = "Code propri\u00e9taire";
    public static final String NAME_KEY = "Nom";
    public static final String COMPANY_NAME_KEY = "Raison sociale";
    public static final String INTERNAL_CODE_KEY = "Code interne";
    private final AddressConverter addressConverter;

    public OwnerConverter(AddressConverter addressConverter) {
        this.addressConverter = addressConverter;
    }

    public String convertToLogbook(OwnerDto owner) {
        LinkedHashMap<String, String> ownerLogbookData = new LinkedHashMap<String, String>();
        ownerLogbookData.put(CODE_KEY, LogbookUtils.getValue((Object)owner.getCode()));
        ownerLogbookData.put(NAME_KEY, LogbookUtils.getValue((Object)owner.getName()));
        ownerLogbookData.put(COMPANY_NAME_KEY, LogbookUtils.getValue((Object)owner.getCompanyName()));
        ownerLogbookData.put(INTERNAL_CODE_KEY, LogbookUtils.getValue((Object)owner.getInternalCode()));
        AddressDto address = owner.getAddress() != null ? owner.getAddress() : new AddressDto();
        this.addressConverter.addAddress(address, ownerLogbookData);
        return ApiUtils.toJson(ownerLogbookData);
    }

    public Owner convertDtoToEntity(OwnerDto dto) {
        Owner owner = new Owner();
        VitamUIUtils.copyProperties((Object)dto, (Object)owner);
        if (dto.getAddress() != null) {
            owner.setAddress(this.addressConverter.convertDtoToEntity(dto.getAddress()));
        }
        return owner;
    }

    public OwnerDto convertEntityToDto(Owner owner) {
        OwnerDto dto = new OwnerDto();
        VitamUIUtils.copyProperties((Object)owner, (Object)dto);
        if (owner.getAddress() != null) {
            dto.setAddress(this.addressConverter.convertEntityToDto(owner.getAddress()));
        }
        return dto;
    }
}

