/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.idp.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.server.idp.domain.IdentityProvider;
import fr.gouv.vitamui.iam.server.idp.service.SpMetadataGenerator;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class IdentityProviderConverter
implements Converter<IdentityProviderDto, IdentityProvider> {
    public static final String NAME_KEY = "Nom";
    public static final String INTERNAL_KEY = "Type";
    public static final String ENABLED_KEY = "Statut";
    public static final String PATTERNS_KEY = "Pattern";
    public static final String TECHNICAL_NAME_KEY = "Nom technique";
    public static final String KEYSTORE_BASE_64_KEY = "Keystore";
    public static final String KEYSTORE_PASSWORD_KEY = "Mot de passe du keystore";
    public static final String IDP_METADATA_KEY = "Idp Metadata";
    public static final String SP_METADATA_KEY = "Sp metadata";
    public static final String MAIL_ATTRIBUTE_KEY = "Attribut mail";
    public static final String IDENTIFIER_ATTRIBUTE_KEY = "Attribut identifier";
    public static final String AUTHENTICATION_REQUEST_BINDING_KEY = "Authentication request binding";
    public static final String MAXIMUM_AUTHENTICATION_LIFE_TIME = "Temps maximum de connexion";
    public static final String WANTS_ASSERTIONS_SIGNED = "Assertions sign\u00e9es";
    public static final String AUTHN_REQUEST_SIGNED = "Requ\u00eate d'authentification sign\u00e9e";
    public static final String PROPAGATE_LOGOUT = "D\u00e9connexion propag\u00e9e";
    public static final String AUTO_PROVISIONING_ENABLED_KEY = "Mise \u00e0 jour automatique des utilisateurs";
    public static final String CLIENT_ID_KEY = "Identifiant client";
    public static final String CLIENT_SECRET_KEY = "Secret client";
    public static final String DISCOVERY_URL_KEY = "URL de d\u00e9couverte des metadata";
    public static final String SCOPE_KEY = "P\u00e9rim\u00e8tre";
    public static final String PREFERRED_JWS_ALGORITHM_KEY = "Algorithme JWS pr\u00e9f\u00e9r\u00e9";
    public static final String CUSTOM_PARAMS_KEY = "Param\u00e8tres sp\u00e9cifiques";
    public static final String USE_STATE_KEY = "Avec state";
    public static final String USE_NONCE_KEY = "Avec nonce";
    public static final String USE_PKCE_KEY = "Avec PKCE";
    public static final String PROTOCOLE_TYPE = "Protocole Type";
    private final SpMetadataGenerator spMetadataGenerator;

    public IdentityProviderConverter(SpMetadataGenerator spMetadataGenerator) {
        this.spMetadataGenerator = spMetadataGenerator;
    }

    public String convertToLogbook(IdentityProviderDto dto) {
        LinkedHashMap<String, String> logbookData = new LinkedHashMap<String, String>();
        logbookData.put(NAME_KEY, dto.getName());
        logbookData.put(TECHNICAL_NAME_KEY, dto.getTechnicalName());
        logbookData.put(INTERNAL_KEY, String.valueOf(dto.getInternal()));
        logbookData.put(ENABLED_KEY, String.valueOf(dto.getEnabled()));
        logbookData.put(PATTERNS_KEY, dto.getPatterns().toString());
        logbookData.put(MAIL_ATTRIBUTE_KEY, String.valueOf(dto.getMailAttribute()));
        logbookData.put(IDENTIFIER_ATTRIBUTE_KEY, String.valueOf(dto.getIdentifierAttribute()));
        logbookData.put(AUTHENTICATION_REQUEST_BINDING_KEY, String.valueOf(dto.getAuthnRequestBinding()));
        logbookData.put(MAXIMUM_AUTHENTICATION_LIFE_TIME, String.valueOf(dto.getMaximumAuthenticationLifetime()));
        logbookData.put(AUTO_PROVISIONING_ENABLED_KEY, String.valueOf(dto.isAutoProvisioningEnabled()));
        logbookData.put(CLIENT_ID_KEY, String.valueOf(dto.getClientId()));
        logbookData.put(DISCOVERY_URL_KEY, String.valueOf(dto.getDiscoveryUrl()));
        return ApiUtils.toJson(logbookData);
    }

    public IdentityProvider convertDtoToEntity(IdentityProviderDto dto) {
        IdentityProvider provider = new IdentityProvider();
        provider.setId(dto.getId());
        provider.setIdentifier(dto.getIdentifier());
        provider.setName(dto.getName());
        provider.setEnabled(dto.getEnabled());
        provider.setInternal(dto.getInternal());
        provider.setTechnicalName(dto.getTechnicalName());
        this.convertPatterns(dto, provider);
        provider.setReadonly(dto.isReadonly());
        provider.setCustomerId(dto.getCustomerId());
        provider.setProtocoleType(dto.getProtocoleType());
        provider.setMailAttribute(dto.getMailAttribute());
        provider.setIdentifierAttribute(dto.getIdentifierAttribute());
        provider.setAutoProvisioningEnabled(dto.isAutoProvisioningEnabled());
        provider.setKeystoreBase64(dto.getKeystoreBase64());
        provider.setKeystorePassword(dto.getKeystorePassword());
        provider.setPrivateKeyPassword(dto.getKeystorePassword());
        dto.setPrivateKeyPassword(dto.getKeystorePassword());
        provider.setIdpMetadata(dto.getIdpMetadata());
        provider.setAuthnRequestBinding(dto.getAuthnRequestBinding());
        provider.setSpMetadata(this.spMetadataGenerator.generate(dto));
        provider.setMaximumAuthenticationLifetime(dto.getMaximumAuthenticationLifetime());
        provider.setWantsAssertionsSigned(dto.getWantsAssertionsSigned());
        provider.setAuthnRequestSigned(dto.getAuthnRequestSigned());
        provider.setPropagateLogout(dto.isPropagateLogout());
        provider.setClientId(dto.getClientId());
        provider.setClientSecret(dto.getClientSecret());
        provider.setDiscoveryUrl(dto.getDiscoveryUrl());
        provider.setScope(dto.getScope());
        provider.setPreferredJwsAlgorithm(dto.getPreferredJwsAlgorithm());
        provider.setCustomParams(dto.getCustomParams());
        provider.setUseState(dto.getUseState());
        provider.setUseNonce(dto.getUseNonce());
        provider.setUsePkce(dto.getUsePkce());
        return provider;
    }

    private void convertPatterns(IdentityProviderDto dto, IdentityProvider provider) {
        if (dto.getPatterns() != null && dto.getPatterns().size() > 0) {
            dto.setPatterns(dto.getPatterns().stream().map(s -> s.startsWith(".*@") ? s : ".*@" + s).collect(Collectors.toList()));
        }
        provider.setPatterns(dto.getPatterns());
    }

    public String buildTechnicalName(String name) {
        int nameHash = Math.abs(name.hashCode());
        String sHash = StringUtils.substring((String)String.valueOf(nameHash), (int)0, (int)6);
        return "idp" + sHash;
    }

    public IdentityProviderDto convertEntityToDto(IdentityProvider provider) {
        IdentityProviderDto dto = new IdentityProviderDto();
        VitamUIUtils.copyProperties((Object)provider, (Object)dto);
        return dto;
    }
}

