/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.externalParameters.service;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.common.enums.Application;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import fr.gouv.vitamui.iam.server.externalParameters.converter.ExternalParametersConverter;
import fr.gouv.vitamui.iam.server.externalParameters.dao.ExternalParametersRepository;
import fr.gouv.vitamui.iam.server.externalParameters.domain.ExternalParameters;
import fr.gouv.vitamui.iam.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.server.security.AbstractResourceClientService;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ExternalParametersService
extends AbstractResourceClientService<ExternalParametersDto, ExternalParameters> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalParametersService.class);
    public static final String EXTERNAL_PARAMETER_IDENTIFIER_PREFIX = "DEFAULT_EXT_PARAM_";
    public static final String EXTERNAL_PARAMETER_NAME_PREFIX = "Liste des param\u00e9trages externes du tenant ";
    public static final String EXTERNAL_PARAMS_PROFILE_NAME_PREFIX = "Profil pour la gestion des param\u00e9trages externes du tenant ";
    private final ExternalParametersRepository externalParametersRepository;
    private final ExternalParametersConverter externalParametersConverter;
    private final SecurityService securityService;
    private final IamLogbookService iamLogbookService;

    @Autowired
    public ExternalParametersService(SequenceGeneratorService sequenceGeneratorService, ExternalParametersRepository externalParametersRepository, ExternalParametersConverter externalParametersConverter, SecurityService securityService, IamLogbookService iamLogbookService) {
        super(sequenceGeneratorService, securityService);
        this.externalParametersRepository = externalParametersRepository;
        this.externalParametersConverter = externalParametersConverter;
        this.securityService = securityService;
        this.iamLogbookService = iamLogbookService;
    }

    public ExternalParametersDto getMyExternalParameters() {
        LOGGER.debug("GetMyExternalParameters");
        AuthUserDto authUserDto = this.securityService.getUser();
        if (authUserDto == null) {
            LOGGER.warn("AuthUser is null");
            return null;
        }
        if (authUserDto.getProfileGroup() == null) {
            LOGGER.warn("AuthUser has no profile group");
            return null;
        }
        if (authUserDto.getProfileGroup().getProfiles() == null) {
            LOGGER.warn("AuthUser profile group has no profiles");
            return null;
        }
        Integer tenant = this.securityService.getTenantIdentifier();
        Optional<ProfileDto> optionalExternalParamsProfileDto = authUserDto.getProfileGroup().getProfiles().stream().filter(p -> Application.EXTERNAL_PARAMS.toString().equalsIgnoreCase(p.getApplicationName())).filter(p -> tenant.equals(p.getTenantIdentifier())).findFirst();
        if (optionalExternalParamsProfileDto.isEmpty()) {
            LOGGER.warn("External parameter profile not found");
            return null;
        }
        ProfileDto externalParametersProfile = optionalExternalParamsProfileDto.get();
        if (externalParametersProfile.getExternalParamId() == null) {
            LOGGER.warn("External parameter profile have no external parameter id");
            return null;
        }
        return (ExternalParametersDto)this.getOne(externalParametersProfile.getExternalParamId());
    }

    @Transactional
    public ExternalParametersDto create(ExternalParametersDto dto) {
        ExternalParametersDto externalParameter = (ExternalParametersDto)super.create((IdDto)dto);
        this.iamLogbookService.createExternalParametersEvent(externalParameter);
        return externalParameter;
    }

    @Transactional
    public ExternalParametersDto update(ExternalParametersDto dto, Collection<EventDiffDto> logbooks) {
        ExternalParametersDto externalParameter = (ExternalParametersDto)super.update((IdDto)dto);
        this.iamLogbookService.updateExternalParametersEvent(externalParameter, logbooks);
        return externalParameter;
    }

    protected ExternalParametersRepository getRepository() {
        return this.externalParametersRepository;
    }

    protected Class<ExternalParameters> getEntityClass() {
        return ExternalParameters.class;
    }

    protected String getObjectName() {
        return "externalParameters";
    }

    protected Converter<ExternalParametersDto, ExternalParameters> getConverter() {
        return this.externalParametersConverter;
    }

    protected String getVersionApiCriteria() {
        return "v1";
    }

    @Generated
    public ExternalParametersRepository getExternalParametersRepository() {
        return this.externalParametersRepository;
    }

    @Generated
    public ExternalParametersConverter getExternalParametersConverter() {
        return this.externalParametersConverter;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }
}

