/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.customer.config;

import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.domain.ServicesData;
import fr.gouv.vitamui.commons.spring.YamlPropertySourceFactory;
import fr.gouv.vitamui.iam.server.customer.config.CustomerInitConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@PropertySource(factory=YamlPropertySourceFactory.class, value={"file:${customer.init.config.file}"})
@ConfigurationProperties(value="customer-init")
public class CustomerInitConfig
implements InitializingBean {
    private List<Role> allRoles;
    private List<ProfileInitConfig> profiles;
    private List<ProfileInitConfig> tenantProfiles;
    private List<ProfileInitConfig> adminProfiles;
    private List<ProfilesGroupInitConfig> profilesGroups;
    private List<UserInitConfig> users;
    private List<String> otherRoles;

    public void afterPropertiesSet() {
        ArrayList allProfiles = new ArrayList();
        if (this.profiles != null) {
            allProfiles.addAll(this.profiles);
        }
        if (this.tenantProfiles != null) {
            allProfiles.addAll(this.tenantProfiles);
        }
        if (this.adminProfiles != null) {
            allProfiles.addAll(this.adminProfiles);
        }
        allProfiles.forEach(p -> {
            Assert.isTrue((!StringUtils.isEmpty((CharSequence)p.getName()) ? 1 : 0) != 0, (String)"name cannot be empty for profile config");
            Assert.isTrue((!StringUtils.isEmpty((CharSequence)p.getAppName()) ? 1 : 0) != 0, (String)"app-name cannot be empty for profile config");
            Assert.isTrue((p.getRoles() != null && !p.getRoles().isEmpty() ? 1 : 0) != 0, (String)"roles list cannot be empty for profile config");
            Assert.isTrue((boolean)p.getRoles().stream().allMatch(new HashSet()::add), (String)"roles list must contains distinct roles for profile config");
        });
        Assert.isTrue((boolean)allProfiles.stream().map(ProfileInitConfig::getName).allMatch(new HashSet()::add), (String)"profiles list contains duplicate name for profile config");
        if (this.profilesGroups != null) {
            List<String> availableProfileNames = allProfiles.stream().map(ProfileInitConfig::getName).toList();
            this.profilesGroups.forEach(g -> {
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)g.getName()) ? 1 : 0) != 0, (String)"name cannot be empty for profiles-groups config");
                Assert.isTrue((g.getProfiles() != null && !g.getProfiles().isEmpty() ? 1 : 0) != 0, (String)"profiles list cannot be empty for profiles-groups config");
                g.getProfiles().forEach(p -> Assert.isTrue((boolean)availableProfileNames.contains(p), (String)("profile '" + p + "' is not defined in profile config")));
                Assert.isTrue((boolean)g.getProfiles().stream().allMatch(new HashSet()::add), (String)"profiles list contains duplicate name for profiles-groups config");
            });
            Assert.isTrue((boolean)this.profilesGroups.stream().map(ProfilesGroupInitConfig::getName).allMatch(new HashSet()::add), (String)"profiles group list contains duplicate name for profiles-groups config");
        }
        if (this.users != null) {
            ArrayList availableProfilesGroupNames = this.profilesGroups != null ? this.profilesGroups.stream().map(ProfilesGroupInitConfig::getName).toList() : new ArrayList();
            this.users.forEach(u -> {
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)u.getLastName()) ? 1 : 0) != 0, (String)"last-name cannot be empty for users config");
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)u.getFirstName()) ? 1 : 0) != 0, (String)"first-name cannot be empty for users config");
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)u.getProfilesGroupName()) ? 1 : 0) != 0, (String)"profiles-group-name cannot be null for users config");
                Assert.isTrue((boolean)availableProfilesGroupNames.contains(u.getProfilesGroupName()), (String)"profiles group name is not defined in profile-groups config");
                Assert.isTrue((!StringUtils.isEmpty((CharSequence)u.getEmailPrefix()) ? 1 : 0) != 0, (String)"email cannot be empty for users config");
            });
            Assert.isTrue((boolean)this.users.stream().map(UserInitConfig::getEmailPrefix).allMatch(new HashSet()::add), (String)"users list contains duplicate email for users config");
        }
        Set profileRoles = allProfiles.stream().flatMap(p -> p.getRoles().stream()).collect(Collectors.toSet());
        List<Role> profileRoleList = profileRoles.stream().map(Role::new).toList();
        ArrayList otherRoleList = this.otherRoles != null ? this.otherRoles.stream().map(Role::new).toList() : new ArrayList();
        this.allRoles = Stream.concat(Stream.concat(profileRoleList.stream(), otherRoleList.stream()), ServicesData.getAllRoles().stream()).collect(Collectors.toList());
    }

    @Generated
    public List<ProfileInitConfig> getProfiles() {
        return this.profiles;
    }

    @Generated
    public List<ProfileInitConfig> getTenantProfiles() {
        return this.tenantProfiles;
    }

    @Generated
    public List<ProfileInitConfig> getAdminProfiles() {
        return this.adminProfiles;
    }

    @Generated
    public List<ProfilesGroupInitConfig> getProfilesGroups() {
        return this.profilesGroups;
    }

    @Generated
    public List<UserInitConfig> getUsers() {
        return this.users;
    }

    @Generated
    public List<String> getOtherRoles() {
        return this.otherRoles;
    }

    @Generated
    public void setProfiles(List<ProfileInitConfig> profiles) {
        this.profiles = profiles;
    }

    @Generated
    public void setTenantProfiles(List<ProfileInitConfig> tenantProfiles) {
        this.tenantProfiles = tenantProfiles;
    }

    @Generated
    public void setAdminProfiles(List<ProfileInitConfig> adminProfiles) {
        this.adminProfiles = adminProfiles;
    }

    @Generated
    public void setProfilesGroups(List<ProfilesGroupInitConfig> profilesGroups) {
        this.profilesGroups = profilesGroups;
    }

    @Generated
    public void setUsers(List<UserInitConfig> users) {
        this.users = users;
    }

    @Generated
    public void setOtherRoles(List<String> otherRoles) {
        this.otherRoles = otherRoles;
    }

    @Generated
    public List<Role> getAllRoles() {
        return this.allRoles;
    }
}

