/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.server.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.domain.VitamConfigurationDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.iam.common.dto.VitamConfigurationResponseDto;
import fr.gouv.vitamui.iam.security.service.SecurityService;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigurationService {
    private final SecurityService securityService;
    private final AdminExternalClient adminExternalClient;
    private final ObjectMapper objectMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);

    @Autowired
    public ConfigurationService(SecurityService securityService, AdminExternalClient adminExternalClient, ObjectMapper objectMapper) {
        this.securityService = securityService;
        this.adminExternalClient = adminExternalClient;
        this.objectMapper = objectMapper;
    }

    public VitamConfigurationDto getVitamPublicConfigurations() {
        LOGGER.debug("Retrieve public vitam configuration ");
        Integer tenantIdentifier = this.securityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.securityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.securityService.getApplicationId());
        try {
            RequestResponse publicConfigurationResponse = this.adminExternalClient.getPublicConfiguration(vitamContext);
            List results = ((VitamConfigurationResponseDto)this.objectMapper.treeToValue((TreeNode)publicConfigurationResponse.toJsonNode(), VitamConfigurationResponseDto.class)).getResults();
            if (CollectionUtils.isEmpty((Collection)results)) {
                throw new VitamClientException("No configuration found");
            }
            return (VitamConfigurationDto)results.get(0);
        }
        catch (JsonProcessingException e1) {
            throw new BadRequestException("Error parsing response ", (Throwable)e1);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Unable to find vitam public configuration", (Throwable)e);
        }
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public AdminExternalClient getAdminExternalClient() {
        return this.adminExternalClient;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

