/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.service;

import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.PuaAttributes;
import fr.gouv.vitamui.pastis.common.dto.PuaData;
import fr.gouv.vitamui.pastis.common.dto.seda.SedaNode;
import fr.gouv.vitamui.pastis.common.util.RNGConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class JsonFromPUA {
    private Long idCounter = 0L;
    private static final String CONTENT = "Content";
    private static final String PROPERTIES = "properties";
    private static final String ITEMS = "items";
    private static final String PATTERN_PROPERTIES = "patternProperties";
    private static final String ADDITIONAL_PROPERTIES = "additionalProperties";

    public ElementProperties getProfileFromPUA(SedaNode sedaTree, JSONObject jsonPUA) throws IOException {
        String controlSchemaString = (String)jsonPUA.get("controlSchema");
        JSONObject controlSchema = new JSONObject(controlSchemaString);
        this.idCounter = 0L;
        ElementProperties root = new ElementProperties();
        root.setAdditionalProperties(controlSchema.optBoolean(ADDITIONAL_PROPERTIES, false));
        root.setName("DescriptiveMetadata");
        Long l = this.idCounter;
        this.idCounter = this.idCounter + 1L;
        root.setId(l);
        root.setLevel(0);
        root.setType(String.valueOf(RNGConstants.MetadaDataType.ELEMENT.getLabel()));
        ElementProperties archiveUnit = this.createChildren(root, "ArchiveUnit");
        archiveUnit.setType(String.valueOf(RNGConstants.MetadaDataType.ELEMENT.getLabel()));
        ElementProperties id = this.createChildren(archiveUnit, "id");
        id.setType(String.valueOf(RNGConstants.MetadaDataType.ATTRIBUTE.getLabel()));
        id.setValueOrData("data");
        id.setDataType(String.valueOf((Object)RNGConstants.DataType.ID));
        this.buildProfile(controlSchema, sedaTree, archiveUnit);
        this.sortTreeWithSeda(archiveUnit, sedaTree);
        return root;
    }

    public void sortTreeWithSeda(ElementProperties tree, SedaNode sedaNode) {
        tree.getChildren().sort(Comparator.comparing(c -> sedaNode.getChildren().stream().map(SedaNode::getName).collect(Collectors.toList()).indexOf(c.getName())));
        for (ElementProperties e : tree.getChildren()) {
            Optional<SedaNode> optionalSedaNode = sedaNode.getChildren().stream().filter(s -> s.getName().equals(e.getName())).findFirst();
            optionalSedaNode.ifPresent(node -> this.sortTreeWithSeda(e, (SedaNode)node));
        }
    }

    private List<String> getRequiredFields(JSONObject controlSchema) {
        ArrayList<String> required = new ArrayList<String>();
        if (controlSchema.has("required")) {
            required.addAll(controlSchema.getJSONArray("required").toList().stream().map(String.class::cast).collect(Collectors.toList()));
        }
        return required;
    }

    private String sanitizeNodeName(String name) {
        return switch (realName = name.replace("_", "")) {
            case "#management" -> "Management";
            case "evId" -> "EventIdentifier";
            case "evTypeProc" -> "evTypeProc";
            case "evType" -> "EventType";
            case "evDateTime" -> "EventDateTime";
            case "evTypeDetail" -> "EventDetail";
            case "outcome" -> "Outcome";
            case "outDetail" -> "OutcomeDetail";
            case "outMessg" -> "OutcomeDetailMessage";
            case "evDetData" -> "EventDetailData";
            case "Algorithm" -> "algorithm";
        };
    }

    private void buildProfile(JSONObject jsonPUA, SedaNode sedaNode, ElementProperties parent) {
        JSONObject properties;
        JSONObject patternProperties;
        List<String> requiredFields = this.getRequiredFields(jsonPUA);
        if (jsonPUA.has(ITEMS)) {
            JSONObject jsonPuaTemp = jsonPUA.getJSONObject(ITEMS);
            jsonPUA.remove(ITEMS);
            jsonPuaTemp.keySet().forEach(key -> jsonPUA.put(key, jsonPuaTemp.get(key)));
        }
        if (jsonPUA.has(PATTERN_PROPERTIES) && (patternProperties = jsonPUA.getJSONObject(PATTERN_PROPERTIES)).has("#management")) {
            JSONObject management = patternProperties.getJSONObject("#management");
            boolean additionalProperties = false;
            if (management.has(ADDITIONAL_PROPERTIES)) {
                additionalProperties = management.getBoolean(ADDITIONAL_PROPERTIES);
            }
            SedaNode managementSeda = sedaNode.getChildren().stream().filter(e -> e.getName().equals("Management")).findAny().get();
            ElementProperties managementProperties = this.createChildren(parent, "Management");
            managementProperties.setCardinality(managementSeda.getCardinality());
            PuaData managementData = new PuaData();
            managementData.setAdditionalProperties(additionalProperties);
            managementProperties.setPuaData(managementData);
            managementProperties.setType(RNGConstants.getTypeElement().get(managementSeda.getElement()));
        }
        if (jsonPUA.has(PROPERTIES) && (properties = jsonPUA.getJSONObject(PROPERTIES)).length() != 0) {
            for (String propertyName : properties.keySet()) {
                Set childrensNames;
                JSONObject propertiesNew;
                List<String> requiredFieldsActual;
                if (propertyName.equals("Rules")) {
                    requiredFieldsActual = this.getRequiredFields(properties.getJSONObject(propertyName).getJSONObject(ITEMS));
                    propertiesNew = properties.getJSONObject(propertyName).getJSONObject(ITEMS).getJSONObject(PROPERTIES);
                    childrensNames = propertiesNew.keySet();
                } else {
                    requiredFieldsActual = requiredFields;
                    propertiesNew = properties;
                    childrensNames = Collections.singleton(propertyName);
                }
                this.buildChildrenProfile(parent, sedaNode, requiredFieldsActual, childrensNames, propertiesNew);
            }
        }
    }

    private void buildChildrenDefinition(SedaNode childrenSedaNode, JSONObject childPua, ElementProperties childrenParent, String childName, List<String> requiredFieldsActual) {
        if (childrenSedaNode != null) {
            ElementProperties childProfile = this.getElementProperties(childrenSedaNode, childrenParent, childName, childPua, requiredFieldsActual.contains(childName));
            this.buildProfile(childPua, childrenSedaNode, childProfile);
        }
    }

    private void buildChildrenProfile(ElementProperties parent, SedaNode sedaNode, List<String> requiredFieldsActual, Set<String> childrensNames, JSONObject propertiesNew) {
        childrensNames.forEach(childName -> {
            ElementProperties childrenParent;
            JSONObject childPua = propertiesNew.getJSONObject(childName);
            String sanitizedChildName = this.sanitizeNodeName((String)childName);
            SedaNode childrenSedaNode = sedaNode.getChild(sanitizedChildName);
            if (childrenSedaNode == null && parent.getName().equals("ArchiveUnit")) {
                ElementProperties content;
                childrenSedaNode = sedaNode.getChild(CONTENT).getChild((String)childName);
                if (childPua.optString("type").equals("string") && null != childrenSedaNode && childrenSedaNode.getCardinality().equals("0-N")) {
                    childPua.put("minItems", 0);
                    childPua.put("maxItems", 1);
                }
                if ((content = (ElementProperties)parent.getChildren().stream().filter(c -> c.getName().equals(CONTENT)).findAny().orElse(null)) == null) {
                    content = this.createChildren(parent, CONTENT);
                    content.setType(String.valueOf(RNGConstants.MetadaDataType.ELEMENT.getLabel()));
                }
                childrenParent = content;
            } else {
                childrenParent = parent;
            }
            this.buildChildrenDefinition(childrenSedaNode, childPua, childrenParent, (String)childName, requiredFieldsActual);
        });
    }

    private ElementProperties getElementProperties(SedaNode sedaNode, ElementProperties parent, String key, JSONObject childPua, Boolean required) {
        ElementProperties childProfile = this.createChildren(parent, key);
        childProfile.setType(RNGConstants.getTypeElement().get(sedaNode.getElement()));
        childProfile.setDataType(sedaNode.getType());
        childProfile.setExternal(sedaNode.isExternal());
        Integer minItems = null;
        Integer maxItems = null;
        if (childPua.has(ITEMS)) {
            JSONObject jsonPuaTemp = childPua.getJSONObject(ITEMS);
            childPua.remove(ITEMS);
            jsonPuaTemp.keySet().forEach(k -> childPua.put(k, jsonPuaTemp.get(k)));
        }
        for (String k2 : childPua.keySet()) {
            PuaAttributes e = PuaAttributes.fromString(k2);
            if (e == null) continue;
            switch (e) {
                case REF: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    this.addRefToElement(childProfile, childPua.getString(k2));
                    break;
                }
                case ENUM: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    List<String> enume = childPua.getJSONArray(k2).toList().stream().map(String.class::cast).collect(Collectors.toList());
                    childProfile.getPuaData().setEnum(enume);
                    break;
                }
                case PATTERN: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setPattern(childPua.getString(k2));
                    break;
                }
                case MIN_LENGTH: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setMinLength(childPua.getInt(k2));
                    break;
                }
                case MAX_LENGTH: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setMaxLength(childPua.getInt(k2));
                    break;
                }
                case MINIMUM: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setMinimum(childPua.getInt(k2));
                    break;
                }
                case MAXIMUM: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setMaximum(childPua.getInt(k2));
                    break;
                }
                case ADDITIONAL_PROPERTIES: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setAdditionalProperties(childPua.getBoolean(k2));
                    break;
                }
                case EXCLUSIVE_MINIMUM: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setExclusiveMinimum(childPua.getBoolean(k2));
                    break;
                }
                case EXCLUSIVE_MAXIMUM: {
                    this.addPuaDataToElementIfNotPresent(childProfile);
                    childProfile.getPuaData().setExclusiveMaximum(childPua.getBoolean(k2));
                    break;
                }
                case DESCRIPTION: {
                    childProfile.setDocumentation(childPua.getString(k2));
                    break;
                }
                case MIN_ITEMS: {
                    minItems = childPua.getInt(k2);
                    break;
                }
                case MAX_ITEMS: {
                    maxItems = childPua.getInt(k2);
                    break;
                }
            }
        }
        childProfile.setCardinality(this.getCardinality(minItems, maxItems, required, sedaNode));
        return childProfile;
    }

    private String getCardinality(Integer minItems, Integer maxItems, Boolean required, SedaNode sedaNode) {
        if (Boolean.TRUE.equals(required)) {
            switch (sedaNode.getCardinality()) {
                case "1-N": 
                case "0-N": {
                    if (null != maxItems) {
                        return "1";
                    }
                    return "1-N";
                }
                case "1": 
                case "0-1": {
                    return "1";
                }
            }
            return "1";
        }
        if (minItems != null && maxItems != null) {
            return minItems + "-" + maxItems;
        }
        if (null != minItems) {
            return minItems + "-N";
        }
        if (null != maxItems) {
            return "0-" + maxItems;
        }
        return sedaNode.getCardinality();
    }

    private void addPuaDataToElementIfNotPresent(ElementProperties childProfile) {
        if (childProfile.getPuaData() == null) {
            childProfile.setPuaData(new PuaData());
        }
    }

    private void addRefToElement(ElementProperties el, String ref) {
        ref = ref.substring(ref.lastIndexOf(47) + 1);
        el.getPuaData().setPattern(ref);
    }

    private ElementProperties createChildren(ElementProperties parent, String name) {
        String realName = this.sanitizeNodeName(name);
        ElementProperties children = new ElementProperties();
        children.setName(realName);
        Long l = this.idCounter;
        this.idCounter = this.idCounter + 1L;
        children.setId(l);
        children.setParentId(parent.getId());
        children.setLevel(parent.getLevel() + 1);
        parent.getChildren().add(children);
        return children;
    }
}

