/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.dto.profiles;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum ProfileVersion {
    VERSION_2_1("2.1"),
    VERSION_2_2("2.2"),
    VERSION_2_3("2.3");

    private final String version;
    private static final Map<String, ProfileVersion> ENUM_BY_VERSION_STRING;

    private ProfileVersion(String version) {
        this.version = version;
    }

    @JsonValue
    public String getVersion() {
        return this.version;
    }

    public static ProfileVersion fromVersionString(String version) {
        return Optional.of(ENUM_BY_VERSION_STRING.get(version)).orElseThrow(() -> new IllegalArgumentException("Unknown version: " + version));
    }

    static {
        ENUM_BY_VERSION_STRING = new HashMap<String, ProfileVersion>();
        for (ProfileVersion profileVersion : ProfileVersion.values()) {
            ENUM_BY_VERSION_STRING.put(profileVersion.version, profileVersion);
        }
    }
}

