/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.dto.profiles;

import fr.gouv.vitamui.commons.api.domain.IdDto;
import java.security.SecureRandom;
import java.sql.Timestamp;
import lombok.Generated;

public class PastisProfile
extends IdDto {
    String type;
    String fileName;
    String baseName;
    String status;
    String lastModified;

    public PastisProfile(String fileName, String status, Long lastModified) {
        this.type = this.getFileType(fileName);
        long idExample = new SecureRandom().nextLong() / 1000L;
        this.setId(String.valueOf(Math.abs(idExample) / 1000L));
        this.fileName = fileName;
        this.baseName = this.getFileBaseName(fileName);
        this.status = status;
        this.lastModified = new Timestamp(lastModified).toString();
    }

    private String getFileType(String fileName) {
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        return tokens[1].equals("rng") ? "PA" : "PUA";
    }

    private String getFileBaseName(String fileName) {
        String[] tokens = fileName.split("\\.(?=[^\\.]+$)");
        return tokens[0];
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getBaseName() {
        return this.baseName;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getLastModified() {
        return this.lastModified;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PastisProfile)) {
            return false;
        }
        PastisProfile other = (PastisProfile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$baseName = this.getBaseName();
        String other$baseName = other.getBaseName();
        if (this$baseName == null ? other$baseName != null : !this$baseName.equals(other$baseName)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$lastModified = this.getLastModified();
        String other$lastModified = other.getLastModified();
        return !(this$lastModified == null ? other$lastModified != null : !this$lastModified.equals(other$lastModified));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PastisProfile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $baseName = this.getBaseName();
        result = result * 59 + ($baseName == null ? 43 : $baseName.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $lastModified = this.getLastModified();
        result = result * 59 + ($lastModified == null ? 43 : $lastModified.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PastisProfile(type=" + this.getType() + ", fileName=" + this.getFileName() + ", baseName=" + this.getBaseName() + ", status=" + this.getStatus() + ", lastModified=" + this.getLastModified() + ")";
    }

    @Generated
    public PastisProfile() {
    }
}

