/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.dto.factory;

import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.factory.AbstractTagFactory;
import fr.gouv.vitamui.pastis.common.dto.factory.AnnotationTag;
import fr.gouv.vitamui.pastis.common.dto.factory.AttributeTag;
import fr.gouv.vitamui.pastis.common.dto.factory.CardinalityTag;
import fr.gouv.vitamui.pastis.common.dto.factory.CardinalityTagFactory;
import fr.gouv.vitamui.pastis.common.dto.factory.DataTag;
import fr.gouv.vitamui.pastis.common.dto.factory.DataTagFactory;
import fr.gouv.vitamui.pastis.common.dto.factory.DocumentationTag;
import fr.gouv.vitamui.pastis.common.dto.factory.ElementTag;
import fr.gouv.vitamui.pastis.common.dto.factory.GrammarTag;
import fr.gouv.vitamui.pastis.common.dto.factory.RngTag;
import fr.gouv.vitamui.pastis.common.dto.factory.StartTag;
import fr.gouv.vitamui.pastis.common.dto.factory.Tag;
import fr.gouv.vitamui.pastis.common.dto.factory.ValueTag;
import fr.gouv.vitamui.pastis.common.util.RNGConstants;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RngTagFactory
implements AbstractTagFactory<RngTag> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RngTagFactory.class);
    private static final String UNDEFINED = "undefined";
    static RngTag rngTree;
    private ValueTag valueRNG;
    private DataTag dataRNG;
    private RngTag elementOrAttributeRNG;
    private AnnotationTag annotationRNG;
    private DocumentationTag documentationRNG;

    @Override
    public RngTag createTag(ElementProperties node, Tag parentNode, int profondeur) {
        this.valueRNG = null;
        this.dataRNG = null;
        CardinalityTag cardinalityRNG = null;
        this.elementOrAttributeRNG = null;
        this.annotationRNG = null;
        this.documentationRNG = null;
        this.checkNode(node);
        if (null != node.getValueOrData() && !node.getValueOrData().equals(UNDEFINED) && node.getValue() == null && node.getValueOrData().equals("data")) {
            this.dataRNG = new DataTag();
        }
        if (null != node.getDataType() && !node.getDataType().equals(UNDEFINED)) {
            if (null != this.valueRNG) {
                this.valueRNG.setDataType(node.getDataType());
            } else if (null != this.dataRNG) {
                this.dataRNG.setDataType(node.getDataType());
            }
        }
        this.setElementAnnotationDocumentation(node);
        if (node.getCardinality() != null) {
            cardinalityRNG = this.checkCardinality(node, parentNode, profondeur);
        }
        RngTag currentTag = this.checkIfElement(node, parentNode, profondeur, this.valueRNG, this.dataRNG, cardinalityRNG, this.elementOrAttributeRNG);
        this.currentTagImplementationAccordingToState(node, parentNode, profondeur, currentTag);
        return rngTree;
    }

    private RngTag checkIfElement(ElementProperties node, Tag parentNode, int profondeur, ValueTag valueRNG, DataTag dataRNG, CardinalityTag cardinalityRNG, RngTag elementOrAttributeRNG) {
        RngTag currentTag = null;
        if (null != elementOrAttributeRNG) {
            if (parentNode != null) {
                LOGGER.debug(this.getClass().getName(), (Object)"Parsing %s", (Object)elementOrAttributeRNG.getName());
            }
            currentTag = this.checkCardinalityElement(parentNode, cardinalityRNG, elementOrAttributeRNG);
            currentTag = this.checkDataTag(node, profondeur, dataRNG, currentTag);
            this.checkValueTag(valueRNG, elementOrAttributeRNG, currentTag);
        }
        return currentTag;
    }

    private void currentTagImplementationAccordingToState(ElementProperties node, Tag parentNode, int profondeur, RngTag currentTag) {
        if (null != currentTag) {
            if (null != parentNode) {
                boolean optionalHasAlreadyCurrentTag;
                RngTag optionalWithChildren = parentNode.getChildren().stream().filter(CardinalityTag.class::isInstance).findAny().orElse(null);
                boolean bl = optionalHasAlreadyCurrentTag = optionalWithChildren != null && optionalWithChildren.children.contains(currentTag);
                if (!optionalHasAlreadyCurrentTag) {
                    currentTag.setParent(parentNode);
                    parentNode.getChildren().add(currentTag);
                }
            } else {
                RngTagFactory.setRngTree(currentTag);
            }
        }
        this.currentNotNullTagImplementationAccordingToState(node, profondeur, currentTag);
    }

    private static void setRngTree(RngTag currentTag) {
        rngTree = currentTag;
    }

    private void currentNotNullTagImplementationAccordingToState(ElementProperties node, int profondeur, RngTag currentTag) {
        if (currentTag instanceof GrammarTag) {
            this.createTag(node, currentTag.getChildren().get(0), profondeur + 1);
        } else {
            for (ElementProperties next : node.getChildren()) {
                if (currentTag instanceof CardinalityTag) {
                    this.createTag(next, currentTag.getChildren().get(0), profondeur + 1);
                    continue;
                }
                this.createTag(next, currentTag, profondeur + 1);
            }
        }
    }

    private RngTag checkCardinalityElement(Tag parentNode, CardinalityTag cardinalityRNG, RngTag elementOrAttributeRNG) {
        RngTag currentTag;
        if (null != cardinalityRNG) {
            cardinalityRNG.getChildren().add(elementOrAttributeRNG);
            elementOrAttributeRNG.setParent(cardinalityRNG);
            currentTag = cardinalityRNG;
        } else {
            currentTag = elementOrAttributeRNG;
            if (parentNode == null) {
                GrammarTag grammarTag = new GrammarTag();
                StartTag startTag = new StartTag();
                startTag.setParent(grammarTag);
                grammarTag.getChildren().add(startTag);
                currentTag = grammarTag;
            }
        }
        return currentTag;
    }

    private RngTag checkDataTag(ElementProperties node, int profondeur, DataTag dataRNG, RngTag currentTag) {
        if (null != dataRNG) {
            DataTagFactory dataTagFactory = new DataTagFactory();
            HashMap<RngTag, RngTag> dataAndCurrentTagMap = new HashMap<RngTag, RngTag>(dataTagFactory.createTagWithTag(node, dataRNG, currentTag, profondeur));
            currentTag = new ArrayList<RngTag>(dataAndCurrentTagMap.values()).get(0);
        }
        return currentTag;
    }

    private void checkValueTag(ValueTag valueRNG, RngTag elementOrAttributeRNG, RngTag currentTag) {
        if (null != valueRNG) {
            if (currentTag.getChildren().isEmpty()) {
                if (currentTag instanceof ElementTag) {
                    this.setProperties(valueRNG, currentTag);
                }
                if (currentTag instanceof AttributeTag) {
                    this.setProperties(valueRNG, currentTag);
                }
            } else if (currentTag instanceof ElementTag) {
                this.setProperties(valueRNG, currentTag);
            } else if (currentTag instanceof AttributeTag) {
                this.setProperties(valueRNG, currentTag);
            } else {
                elementOrAttributeRNG.setValueTag(valueRNG);
                valueRNG.setParent(elementOrAttributeRNG);
            }
        }
    }

    private void setProperties(ValueTag valueRNG, RngTag currentTag) {
        currentTag.setValueTag(valueRNG);
        valueRNG.setParent(currentTag);
    }

    private void checkNode(ElementProperties node) {
        if (null != node.getValue() && !node.getValue().equals(UNDEFINED)) {
            this.valueRNG = new ValueTag();
            this.valueRNG.setValue(node.getValue());
        }
        if ((long)node.getChildren().size() == 0L && this.valueRNG == null && RNGConstants.getTypesMap().containsKey(node.getName())) {
            this.dataRNG = new DataTag();
            this.dataRNG.setDataType(RNGConstants.getTypesMap().get(node.getName()).getLabel());
        }
    }

    private void setElementAnnotationDocumentation(ElementProperties node) {
        if (null != node.getDocumentation()) {
            this.annotationRNG = new AnnotationTag();
            this.documentationRNG = new DocumentationTag();
            this.documentationRNG.setDocumentation(node.getDocumentation());
            this.annotationRNG.setDocumentationTag(this.documentationRNG);
        }
        if (null != node.getType() && !node.getType().equals(UNDEFINED)) {
            if (node.getType().equals("element")) {
                this.elementOrAttributeRNG = new ElementTag();
            } else if (node.getType().equals("attribute")) {
                this.elementOrAttributeRNG = new AttributeTag();
            }
            if (null != node.getName() && !node.getName().equals(UNDEFINED) && this.elementOrAttributeRNG != null) {
                this.elementOrAttributeRNG.setName(node.getName());
            }
        }
        if (null != this.documentationRNG && this.elementOrAttributeRNG != null) {
            this.elementOrAttributeRNG.getChildren().add(this.annotationRNG);
            this.annotationRNG.setParent(this.elementOrAttributeRNG);
        }
    }

    private CardinalityTag checkCardinality(ElementProperties node, Tag parentNode, int profondeur) {
        CardinalityTagFactory cardinalityFactory = new CardinalityTagFactory();
        CardinalityTag cardinalityTag = cardinalityFactory.createTag(node, parentNode, profondeur);
        LOGGER.debug(this.getClass().getName(), (Object)"Parsing %s", (Object)cardinalityTag.getTagName());
        return cardinalityTag;
    }
}

