/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.service;

import fr.gouv.vitamui.commons.api.exception.IngestFileGenerationException;
import fr.gouv.vitamui.commons.vitam.seda.LevelType;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.ingest.common.dto.ArchiveUnitDto;
import fr.gouv.vitamui.ingest.common.enums.Extension;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.Paragraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class IngestGeneratorODTFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestGeneratorODTFile.class);
    public static final String FIRST_TITLE = "Bordereau de versement d'archives";
    public static final String SECOND_TITLE = "D\u00e9tail des unit\u00e9s archivistiques de type r\u00e9pertoire et dossier:";
    private static final String NO_TEXT = "_ _ _ _";
    private static final String LOGO_PATH = "/logo_ministere.";
    @Value(value="${tmp_folder_path}")
    private String tmpFolderPath;

    public void generateDocumentHeader(TextDocument document, CustomerDto myCustomer, Resource customerLogo) throws IOException, URISyntaxException {
        Border border = new Border(Color.WHITE, 1.0, StyleTypeDefinitions.SupportedLinearMeasure.PT);
        Table headerTable = document.addTable(1, 2);
        headerTable.getRowByIndex(0).setHeight(35.0, false);
        headerTable.getColumnByIndex(1).setWidth(35.0);
        Font font = headerTable.getCellByPosition(0, 0).getFont();
        font.setSize(11.0);
        headerTable.getCellByPosition(0, 0).setFont(font);
        headerTable.getCellByPosition(0, 0).setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
        headerTable.getCellByPosition(1, 0).setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
        if (myCustomer != null) {
            Cell cell = headerTable.getCellByPosition(0, 0);
            cell.addParagraph(myCustomer.getName());
            cell.addParagraph(myCustomer.getCompanyName());
            cell.addParagraph("");
            cell.addParagraph(myCustomer.getAddress().getStreet());
            cell.addParagraph(myCustomer.getAddress().getCity());
            cell.addParagraph(myCustomer.getAddress().getZipCode());
            cell.addParagraph(myCustomer.getAddress().getCountry());
        }
        if (myCustomer != null && myCustomer.isHasCustomGraphicIdentity() && customerLogo != null) {
            byte[] customerLogoBytes = customerLogo.getInputStream().readAllBytes();
            String customerLogoBase64Image = Base64.getEncoder().encodeToString(customerLogoBytes);
            byte[] customerLogoDecodedBytes = Base64.getDecoder().decode(customerLogoBase64Image);
            String imgFile = this.tmpFolderPath + LOGO_PATH + this.getExtensionByCustomerLogo(customerLogoBase64Image).toLowerCase();
            FileUtils.writeByteArrayToFile((File)new File(imgFile), (byte[])customerLogoDecodedBytes);
            headerTable.getCellByPosition(1, 0).setImage(new URI(imgFile));
            FileUtils.forceDelete((File)new File(imgFile));
        }
        this.addSpace(document);
    }

    public void generateFirstTitle(TextDocument document) {
        this.addSpace(document);
        this.generateTile(document, 22, FIRST_TITLE, StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
    }

    public void generateSecondtTitle(TextDocument document) {
        this.generateTile(document, 14, SECOND_TITLE, StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
    }

    public void generateServicesTable(TextDocument document, Document manifest) {
        this.addSpace(document);
        Table table = document.addTable(2, 2);
        Cell cellOne = table.getColumnByIndex(0).getCellByIndex(0);
        Cell cellTwo = table.getColumnByIndex(0).getCellByIndex(1);
        cellOne.setStringValue("Service producteur :");
        cellTwo.setStringValue("Service versant :");
        table.getColumnByIndex(0).setWidth(50.0);
        Font fontCellOne = cellOne.getFont();
        fontCellOne.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        cellOne.setFont(fontCellOne);
        Font fontCellTwo = cellTwo.getFont();
        fontCellTwo.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        cellTwo.setFont(fontCellTwo);
        table.getColumnByIndex(1).getCellByIndex(0).setStringValue(this.getManifestPrincipalData(manifest, "OriginatingAgencyIdentifier"));
        table.getColumnByIndex(1).getCellByIndex(1).setStringValue(this.getServiceVersant(manifest));
        this.addSpace(document);
    }

    public void generateDepositDataTable(TextDocument document, Document manifest, List<ArchiveUnitDto> archiveUnitDtoList) {
        this.addSpace(document);
        Table table = document.addTable(4, 2);
        table.getColumnByIndex(0).setWidth(50.0);
        Cell tableCellOne = table.getColumnByIndex(0).getCellByIndex(0);
        tableCellOne.setStringValue("Num\u00e9ro du versement :");
        Font fontCellOne = tableCellOne.getFont();
        fontCellOne.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        tableCellOne.setFont(fontCellOne);
        Cell tableCellTwo = table.getColumnByIndex(0).getCellByIndex(1);
        tableCellTwo.setStringValue("Pr\u00e9sentation du contenu :");
        Font fontCellTwo = tableCellTwo.getFont();
        fontCellTwo.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        tableCellTwo.setFont(fontCellTwo);
        Cell tableCellThree = table.getColumnByIndex(0).getCellByIndex(2);
        tableCellThree.setStringValue("Dates extr\u00eames :");
        Font fontCellThree = tableCellThree.getFont();
        fontCellThree.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        tableCellThree.setFont(fontCellThree);
        Cell tableCellFour = table.getColumnByIndex(0).getCellByIndex(3);
        tableCellFour.setStringValue("Historique des conservations :");
        Font fontCellFour = tableCellFour.getFont();
        fontCellFour.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        tableCellFour.setFont(fontCellFour);
        table.getColumnByIndex(1).getCellByIndex(0).setStringValue(this.getManifestPrincipalData(manifest, "MessageIdentifier"));
        table.getColumnByIndex(1).getCellByIndex(1).setStringValue(this.getManifestPrincipalData(manifest, "Comment"));
        if (!archiveUnitDtoList.isEmpty()) {
            table.getColumnByIndex(1).getCellByIndex(2).addParagraph("Date de d\u00e9but : " + this.getStartedDate(this.getArchiveUnitStartDatesList(archiveUnitDtoList)));
            table.getColumnByIndex(1).getCellByIndex(2).addParagraph("Date de fin : " + this.getEndDate(this.getArchiveUnitEndDatesList(archiveUnitDtoList)));
        }
        table.getColumnByIndex(1).getCellByIndex(3).setStringValue(this.getCustodialHistory(manifest));
        this.addSpace(document);
    }

    public void generateOperationDataTable(TextDocument document, Document manifest, String id) {
        this.addSpace(document);
        Table table = document.addTable(2, 2);
        table.getColumnByIndex(0).setWidth(50.0);
        Cell cellOne = table.getColumnByIndex(0).getCellByIndex(0);
        cellOne.setStringValue("Nombre de fichiers binaires:");
        Font fontCellOne = cellOne.getFont();
        fontCellOne.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        cellOne.setFont(fontCellOne);
        Cell cellTwo = table.getColumnByIndex(0).getCellByIndex(1);
        cellTwo.setStringValue("Identifiant de l\u2019op\u00e9ration d\u2019entr\u00e9e :");
        Font fontCellTwo = cellTwo.getFont();
        fontCellTwo.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        cellTwo.setFont(fontCellTwo);
        table.getColumnByIndex(1).getCellByIndex(0).setStringValue(this.getBinaryFileNumber(manifest) + " fichiers");
        table.getColumnByIndex(1).getCellByIndex(1).setStringValue(id);
        this.addSpace(document);
        this.addSpace(document);
    }

    public void generateResponsibleSignatureTable(TextDocument document) {
        this.addSpace(document);
        Border border = new Border(Color.WHITE, 1.0, StyleTypeDefinitions.SupportedLinearMeasure.PT);
        Table table = document.addTable(2, 2);
        table.getRowByIndex(0).setHeight(25.0, false);
        table.getRowByIndex(1).setHeight(25.0, false);
        Cell tableCellOne = table.getColumnByIndex(0).getCellByIndex(0);
        tableCellOne.setStringValue("Date de signature : ");
        tableCellOne.addParagraph("");
        Cell tableCellTwo = table.getColumnByIndex(0).getCellByIndex(1);
        tableCellTwo.setStringValue("Le responsable du versement :");
        tableCellTwo.addParagraph("");
        Cell tableCellThree = table.getColumnByIndex(1).getCellByIndex(0);
        tableCellThree.setStringValue("Date de signature :");
        tableCellThree.addParagraph("");
        Cell tableCellFour = table.getColumnByIndex(1).getCellByIndex(1);
        tableCellFour.setStringValue("Le responsable du service d'archives :");
        tableCellFour.addParagraph("");
        tableCellOne.setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
        tableCellTwo.setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
        tableCellThree.setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
        tableCellFour.setBorders(StyleTypeDefinitions.CellBordersType.NONE, border);
    }

    public void generateArchiveUnitDetailsTable(TextDocument document, List<ArchiveUnitDto> archiveUnitDtoList) {
        Table dynamicTable = document.addTable(1, 4);
        dynamicTable.getCellByPosition(0, 0).addParagraph("Identifiant SAE VAS").setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        dynamicTable.getCellByPosition(1, 0).addParagraph("Titre").setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        dynamicTable.getCellByPosition(2, 0).addParagraph("Date de d\u00e9but").setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        dynamicTable.getCellByPosition(3, 0).addParagraph("Date de fin").setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        dynamicTable.getColumnByIndex(0).setWidth(46.5);
        dynamicTable.getColumnByIndex(1).setWidth(77.5);
        dynamicTable.getColumnByIndex(2).setWidth(23.0);
        dynamicTable.getColumnByIndex(3).setWidth(23.0);
        archiveUnitDtoList.stream().forEach(archiveUnitDto -> {
            Row row = dynamicTable.appendRow();
            Font fontCellOne = row.getCellByIndex(0).getFont();
            fontCellOne.setSize(9.0);
            row.getCellByIndex(0).setFont(fontCellOne);
            Font fontCellTwo = row.getCellByIndex(1).getFont();
            fontCellTwo.setSize(9.5);
            row.getCellByIndex(1).setFont(fontCellTwo);
            row.getCellByIndex(0).addParagraph(archiveUnitDto.getSystemId());
            row.getCellByIndex(1).addParagraph(archiveUnitDto.getTitle());
            row.getCellByIndex(2).addParagraph(this.transformDate(archiveUnitDto.getStartDate().split("T")[0]));
            row.getCellByIndex(3).addParagraph(this.transformDate(archiveUnitDto.getEndDate().split("T")[0]));
        });
        Font fontCellOne = dynamicTable.getRowByIndex(0).getCellByIndex(0).getFont();
        fontCellOne.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        dynamicTable.getRowByIndex(0).getCellByIndex(0).setFont(fontCellOne);
        Font fontCellTwo = dynamicTable.getRowByIndex(0).getCellByIndex(1).getFont();
        fontCellTwo.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        dynamicTable.getRowByIndex(0).getCellByIndex(1).setFont(fontCellTwo);
        Font fontCellThree = dynamicTable.getRowByIndex(0).getCellByIndex(2).getFont();
        fontCellThree.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        dynamicTable.getRowByIndex(0).getCellByIndex(2).setFont(fontCellThree);
        Font fontCellFour = dynamicTable.getRowByIndex(0).getCellByIndex(3).getFont();
        fontCellFour.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        dynamicTable.getRowByIndex(0).getCellByIndex(3).setFont(fontCellFour);
        dynamicTable.getCellByPosition(0, 0).setCellBackgroundColor(Color.GRAY);
        dynamicTable.getCellByPosition(1, 0).setCellBackgroundColor(Color.GRAY);
        dynamicTable.getCellByPosition(2, 0).setCellBackgroundColor(Color.GRAY);
        dynamicTable.getCellByPosition(3, 0).setCellBackgroundColor(Color.GRAY);
    }

    public List<ArchiveUnitDto> getValuesForDynamicTable(Document atr, Document manifest) {
        ArrayList<ArchiveUnitDto> archiveUnitDtoList = new ArrayList<ArchiveUnitDto>();
        Map<String, String> systemIds = this.getSystemIdValues(atr);
        manifest.getDocumentElement().normalize();
        NodeList archiveUnitsNodes = manifest.getDocumentElement().getElementsByTagName("ArchiveUnit");
        for (int item = 0; item < archiveUnitsNodes.getLength(); ++item) {
            Element contentElement;
            Element archiveUnitElement;
            NodeList contentElements;
            Node archiveUnitNode = archiveUnitsNodes.item(item);
            if (archiveUnitNode.getNodeType() != 1 || (contentElements = (archiveUnitElement = (Element)archiveUnitNode).getElementsByTagName("Content")).getLength() == 0 || this.isAttachmentUnit(archiveUnitElement) || systemIds.get(((Element)(contentElement = (Element)contentElements.item(0)).getParentNode()).getAttribute("id")) == null || StringUtils.equals((CharSequence)this.getData(contentElement, "DescriptionLevel"), (CharSequence)LevelType.SUBSERIES.value())) continue;
            ArchiveUnitDto archiveUnitDto = new ArchiveUnitDto();
            archiveUnitDto.setId(((Element)contentElement.getParentNode()).getAttribute("id"));
            archiveUnitDto.setTitle(this.getData(contentElement, "Title"));
            archiveUnitDto.setEndDate(this.getData(contentElement, "EndDate"));
            archiveUnitDto.setStartDate(this.getData(contentElement, "StartDate"));
            archiveUnitDto.setSystemId(systemIds.get(((Element)contentElement.getParentNode()).getAttribute("id")));
            archiveUnitDtoList.add(archiveUnitDto);
        }
        return archiveUnitDtoList;
    }

    public Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception e) {
            LOGGER.error("Error while converting string to XML Document {}", (Object)e.getMessage());
            throw new IngestFileGenerationException("Error while converting string to XML Document {}", (Throwable)e);
        }
    }

    public String resourceAsString(Resource resource) {
        String string;
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        try {
            string = FileCopyUtils.copyToString((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Error while converting string to Resource Document {}", (Object)e.getMessage());
                throw new UncheckedIOException("Error while converting string to Resource Document", e);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    private String getEndDate(List<String> listOfDate) {
        if (!CollectionUtils.isEmpty(listOfDate)) {
            String lastEndDate = (String)listOfDate.stream().map(this::manageDateFormat).sorted().collect(Collectors.toList()).get(listOfDate.size() - 1);
            return this.transformDate(lastEndDate);
        }
        return NO_TEXT;
    }

    private Map<String, String> getSystemIdValues(Document document) {
        HashMap<String, String> map = new HashMap<String, String>();
        document.getDocumentElement().normalize();
        NodeList nList = document.getElementsByTagName("ArchiveUnit");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            map.put(eElement.getAttribute("id"), eElement.getElementsByTagName("SystemId").item(0).getTextContent());
        }
        return map;
    }

    private String getServiceVersant(Document document) {
        return document.getElementsByTagName("SubmissionAgencyIdentifier").getLength() == 0 ? this.getManifestPrincipalData(document, "OriginatingAgencyIdentifier") : document.getElementsByTagName("SubmissionAgencyIdentifier").item(0).getTextContent();
    }

    private String getManifestPrincipalData(Document document, String tageName) {
        document.getDocumentElement().normalize();
        return document.getElementsByTagName(tageName) != null && document.getElementsByTagName(tageName).getLength() > 0 ? document.getElementsByTagName(tageName).item(0).getTextContent() : NO_TEXT;
    }

    private String getCustodialHistory(Document document) {
        return document.getElementsByTagName("CustodialHistory").getLength() == 0 ? "historique indisponible" : document.getElementsByTagName("CustodialHistory").item(0).getTextContent();
    }

    private int getBinaryFileNumber(Document document) {
        return document.getElementsByTagName("BinaryDataObject").getLength();
    }

    private List<String> getArchiveUnitStartDatesList(List<ArchiveUnitDto> archiveUnitDtoList) {
        return archiveUnitDtoList.stream().map(ArchiveUnitDto::getStartDate).filter(startDate -> !startDate.equals(NO_TEXT)).collect(Collectors.toList());
    }

    private List<String> getArchiveUnitEndDatesList(List<ArchiveUnitDto> archiveUnitDtoList) {
        return archiveUnitDtoList.stream().map(ArchiveUnitDto::getEndDate).filter(endDate -> !endDate.equals(NO_TEXT)).collect(Collectors.toList());
    }

    private String transformDate(String date) {
        if (!date.equals(NO_TEXT)) {
            LocalDate finalDate = LocalDate.parse(date);
            return finalDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        }
        return date;
    }

    private void addSpace(TextDocument document) {
        document.addParagraph("");
    }

    private String getExtensionByCustomerLogo(String customerLogoBase64Image) {
        return Extension.findExtensionFromValue(Character.toString(customerLogoBase64Image.charAt(0))).toString();
    }

    private void generateTile(TextDocument document, int size, String tilte, StyleTypeDefinitions.HorizontalAlignmentType horizontalAlignmentType) {
        Paragraph paragraph = document.addParagraph(tilte);
        paragraph.setHorizontalAlignment(horizontalAlignmentType);
        Font font = paragraph.getFont();
        font.setFontStyle(StyleTypeDefinitions.FontStyle.BOLD);
        font.setSize((double)size);
        paragraph.setFont(font);
        this.addSpace(document);
    }

    private String getStartedDate(List<String> listOfDate) {
        if (!CollectionUtils.isEmpty(listOfDate)) {
            String firstStartDate = listOfDate.stream().map(this::manageDateFormat).sorted().findFirst().get();
            return this.transformDate(firstStartDate);
        }
        return NO_TEXT;
    }

    private String getData(Element element, String tagName) {
        return element.getElementsByTagName(tagName).getLength() == 0 ? NO_TEXT : element.getElementsByTagName(tagName).item(0).getTextContent();
    }

    private String manageDateFormat(String date) {
        return date.contains("T") ? date.substring(0, date.indexOf("T")) : date;
    }

    private boolean isAttachmentUnit(Element archiveUnitElement) {
        return archiveUnitElement.getElementsByTagName("Management").getLength() > 0 && archiveUnitElement.getElementsByTagName("UpdateOperation").getLength() > 0;
    }
}

