/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitamui.commons.api.converter.AccessContractConverter;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractCommonService;
import fr.gouv.vitamui.commons.vitam.api.dto.AccessContractResponseDto;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IngestAccessContractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestAccessContractService.class);
    private AccessContractCommonService accessContractCommonService;
    private ObjectMapper objectMapper;

    @Autowired
    public IngestAccessContractService(AccessContractCommonService accessContractCommonService, ObjectMapper objectMapper) {
        this.accessContractCommonService = accessContractCommonService;
        this.objectMapper = objectMapper;
    }

    public Optional<AccessContractDto> getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.debug("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractCommonService.findAccessContractById(vitamContext, identifier);
            AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
            if (CollectionUtils.isEmpty((Collection)accessContractResponseDto.getResults())) {
                return Optional.empty();
            }
            return Optional.of(AccessContractConverter.convertVitamToDto((AccessContractModel)((AccessContractModel)accessContractResponseDto.getResults().get(0))));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contrat", e);
        }
    }
}

